/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.predicate.AbstractSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmJunctionPredicate
extends AbstractSqmPredicate {
    private final Predicate.BooleanOperator booleanOperator;
    private final List<SqmPredicate> predicates;

    public SqmJunctionPredicate(Predicate.BooleanOperator booleanOperator, SqmPredicate leftHandPredicate, SqmPredicate rightHandPredicate, NodeBuilder nodeBuilder) {
        super(leftHandPredicate.getExpressible(), nodeBuilder);
        this.booleanOperator = booleanOperator;
        this.predicates = new ArrayList<SqmPredicate>(2);
        this.predicates.add(leftHandPredicate);
        this.predicates.add(rightHandPredicate);
    }

    public SqmJunctionPredicate(Predicate.BooleanOperator booleanOperator, List<SqmPredicate> predicates, NodeBuilder nodeBuilder) {
        super(predicates.get(0).getNodeType(), nodeBuilder);
        this.booleanOperator = booleanOperator;
        this.predicates = predicates;
    }

    @Override
    public SqmJunctionPredicate copy(SqmCopyContext context) {
        SqmJunctionPredicate existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        ArrayList<SqmPredicate> predicates = new ArrayList<SqmPredicate>(this.predicates.size());
        for (SqmPredicate predicate : this.predicates) {
            predicates.add(predicate.copy(context));
        }
        SqmJunctionPredicate predicate = context.registerCopy(this, new SqmJunctionPredicate(this.booleanOperator, predicates, this.nodeBuilder()));
        this.copyTo(predicate, context);
        return predicate;
    }

    public List<SqmPredicate> getPredicates() {
        return this.predicates;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitJunctionPredicate(this);
    }

    @Override
    public Predicate.BooleanOperator getOperator() {
        return this.booleanOperator;
    }

    public boolean isNegated() {
        return false;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        return this.predicates;
    }

    @Override
    public SqmPredicate not() {
        return new SqmNegatedPredicate(this, (NodeBuilder)this.nodeBuilder());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        String separator = this.booleanOperator == Predicate.BooleanOperator.AND ? " and " : " or ";
        this.appendJunctionHqlString(this.predicates.get(0), sb);
        for (int i = 1; i < this.predicates.size(); ++i) {
            sb.append(separator);
            this.appendJunctionHqlString(this.predicates.get(i), sb);
        }
    }

    private void appendJunctionHqlString(SqmPredicate p, StringBuilder sb) {
        if (p instanceof SqmJunctionPredicate) {
            SqmJunctionPredicate junction = (SqmJunctionPredicate)p;
            if (this.booleanOperator == junction.getOperator() || this.booleanOperator == Predicate.BooleanOperator.OR) {
                junction.appendHqlString(sb);
            } else {
                sb.append('(');
                junction.appendHqlString(sb);
                sb.append(')');
            }
        } else {
            p.appendHqlString(sb);
        }
    }
}

