/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import io.airlift.airline.Command;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.queue.QueueAbstract;

@Command(name="create", description="create a queue or topic")
public class CreateQueue
extends QueueAbstract {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.createQueue(context);
        return null;
    }

    private void createQueue(final ActionContext context) throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"createQueue", (Object[])new Object[]{CreateQueue.this.getAddress(true), CreateQueue.this.getRoutingType(), CreateQueue.this.getName(), CreateQueue.this.getFilter(), CreateQueue.this.isDurable(), CreateQueue.this.getMaxConsumers(-1), CreateQueue.this.isPurgeOnNoConsumers(true), CreateQueue.this.isAutoCreateAddress()});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                String result = ManagementHelper.getResult((ICoreMessage)reply, String.class) + " created successfully.";
                context.out.println(result);
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                context.err.println("Failed to create queue " + CreateQueue.this.getName() + ". Reason: " + errMsg);
            }
        });
    }
}

