/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.mw.wst11.UserTransaction;
import com.arjuna.mw.wst11.UserTransactionFactory;
import com.arjuna.wsc.AlreadyRegisteredException;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.Volatile2PCParticipant;
import com.arjuna.wst.WrongStateException;
import jakarta.transaction.SystemException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.txbridge.inbound.BridgeDurableParticipant;
import org.jboss.jbossts.txbridge.inbound.BridgeVolatileParticipant;
import org.jboss.jbossts.txbridge.inbound.InboundBridge;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class InboundBridgeManager {
    private static final ConcurrentMap<String, InboundBridge> inboundBridgeMappings = new ConcurrentHashMap<String, InboundBridge>();
    private static final Set<Xid> liveXids = new HashSet<Xid>();

    public static InboundBridge getInboundBridge() throws XAException, WrongStateException, UnknownTransactionException, com.arjuna.wst.SystemException, SystemException, AlreadyRegisteredException {
        txbridgeLogger.logger.trace((Object)"InboundBridgeManager.getInboundBridge()");
        UserTransaction wsUserTransaction = UserTransactionFactory.userTransaction();
        String externalTxId = wsUserTransaction.toString();
        int wsTxnTimeout = wsUserTransaction.getTimeout();
        if (!inboundBridgeMappings.containsKey(externalTxId)) {
            InboundBridgeManager.createMapping(externalTxId, wsTxnTimeout);
        }
        return (InboundBridge)inboundBridgeMappings.get(externalTxId);
    }

    static InboundBridge getInboundBridge(String externalTxId) {
        return (InboundBridge)inboundBridgeMappings.get(externalTxId);
    }

    public static synchronized void removeMapping(String externalTxId) {
        InboundBridge inboundBridge;
        txbridgeLogger.logger.trace((Object)("InboundBridgeManager.removeMapping(externalTxId=" + externalTxId + ")"));
        if (externalTxId != null && (inboundBridge = (InboundBridge)inboundBridgeMappings.remove(externalTxId)) != null) {
            liveXids.remove(inboundBridge.getXid());
        }
    }

    public static synchronized boolean isLive(Xid xid) {
        return liveXids.contains(xid);
    }

    private static synchronized void createMapping(String externalTxId, int timeout) throws XAException, WrongStateException, UnknownTransactionException, com.arjuna.wst.SystemException, SystemException, AlreadyRegisteredException {
        txbridgeLogger.logger.trace((Object)("InboundBridgeManager.createMapping(externalTxId=" + externalTxId + ")"));
        if (inboundBridgeMappings.containsKey(externalTxId)) {
            return;
        }
        TransactionManager transactionManager = TransactionManagerFactory.transactionManager();
        Xid xid = XATxConverter.getXid((Uid)new Uid(), (boolean)false, (int)131080);
        BridgeDurableParticipant bridgeDurableParticipant = new BridgeDurableParticipant(externalTxId, xid);
        String participantId = "BridgeDurableParticipant_" + new Uid().toString();
        transactionManager.enlistForDurableTwoPhase((Durable2PCParticipant)bridgeDurableParticipant, participantId);
        BridgeVolatileParticipant bridgeVolatileParticipant = new BridgeVolatileParticipant(externalTxId, xid);
        transactionManager.enlistForVolatileTwoPhase((Volatile2PCParticipant)bridgeVolatileParticipant, new Uid().toString());
        InboundBridge inboundBridge = new InboundBridge(xid, timeout);
        inboundBridgeMappings.put(externalTxId, inboundBridge);
        liveXids.add(inboundBridge.getXid());
    }
}

