/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorRootContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorValueBridgeNode<V, F>
extends PojoIndexingProcessor<V> {
    private final BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder;
    private final IndexFieldReference<F> indexFieldReference;

    public PojoIndexingProcessorValueBridgeNode(BeanHolder<? extends ValueBridge<? super V, F>> bridgeHolder, IndexFieldReference<F> indexFieldReference) {
        this.bridgeHolder = bridgeHolder;
        this.indexFieldReference = indexFieldReference;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ValueBridge::close, this.bridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.bridgeHolder);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"apply value bridge");
        builder.attribute("bridge", this.bridgeHolder);
        builder.attribute("indexField", this.indexFieldReference);
    }

    @Override
    public void process(DocumentElement target, V source, PojoIndexingProcessorRootContext context) {
        Object indexFieldValue = ((ValueBridge)this.bridgeHolder.get()).toIndexedValue(source, context.sessionContext().mappingContext().valueBridgeToIndexedValueContext());
        target.addValue(this.indexFieldReference, indexFieldValue);
    }
}

