/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing.contrib.jaxrs2.serialization;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.Tags;
import io.smallrye.opentracing.contrib.jaxrs2.internal.SpanWrapper;
import io.smallrye.opentracing.contrib.jaxrs2.serialization.InterceptorSpanDecorator;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.InterceptorContext;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class TracingInterceptor
implements WriterInterceptor,
ReaderInterceptor {
    private final Tracer tracer;
    private final Collection<InterceptorSpanDecorator> spanDecorators;

    public TracingInterceptor(Tracer tracer, List<InterceptorSpanDecorator> spanDecorators) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(spanDecorators);
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<InterceptorSpanDecorator>(spanDecorators);
    }

    /*
     * Exception decompiling
     */
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        Span span = this.buildSpan((InterceptorContext)context, "serialize");
        try (Scope scope = this.tracer.activateSpan(span);){
            this.decorateWrite((InterceptorContext)context, span);
            context.proceed();
        }
        catch (Exception e) {
            Tags.ERROR.set(span, Boolean.valueOf(true));
            throw e;
        }
        finally {
            span.finish();
        }
    }

    private Span buildSpan(InterceptorContext context, String operationName) {
        SpanWrapper spanWrapper = this.findSpan(context);
        if (spanWrapper == null) {
            return NoopSpan.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName);
        if (spanWrapper.isFinished()) {
            spanBuilder.addReference("follows_from", spanWrapper.get().context());
        } else {
            spanBuilder.asChildOf(spanWrapper.get());
        }
        return spanBuilder.start();
    }

    protected abstract SpanWrapper findSpan(InterceptorContext var1);

    private void decorateRead(InterceptorContext context, Span span) {
        for (InterceptorSpanDecorator decorator : this.spanDecorators) {
            decorator.decorateRead(context, span);
        }
    }

    private void decorateWrite(InterceptorContext context, Span span) {
        for (InterceptorSpanDecorator decorator : this.spanDecorators) {
            decorator.decorateWrite(context, span);
        }
    }
}

