/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaElementImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexCompositeNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexObjectFieldBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexRootBuilder;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactory;
import org.hibernate.search.engine.mapper.mapping.building.impl.ConfiguredIndexSchemaNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.impl.IndexedEmbeddedBindingContextImpl;
import org.hibernate.search.engine.mapper.mapping.building.impl.NotifyingNestingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexSchemaContributionListener;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedDefinition;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEmbeddedPathTracker;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingMapperContext;

abstract class AbstractIndexBindingContext<B extends IndexCompositeNodeBuilder>
implements IndexBindingContext {
    private final IndexedEntityBindingMapperContext mapperContext;
    private final IndexRootBuilder indexRootBuilder;
    final B indexSchemaObjectNodeBuilder;
    final ConfiguredIndexSchemaNestingContext nestingContext;

    AbstractIndexBindingContext(IndexedEntityBindingMapperContext mapperContext, IndexRootBuilder indexRootBuilder, B indexSchemaObjectNodeBuilder, ConfiguredIndexSchemaNestingContext nestingContext) {
        this.mapperContext = mapperContext;
        this.indexRootBuilder = indexRootBuilder;
        this.indexSchemaObjectNodeBuilder = indexSchemaObjectNodeBuilder;
        this.nestingContext = nestingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexSchemaObjectNodeBuilder=" + this.indexSchemaObjectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public IndexFieldTypeFactory createTypeFactory(IndexFieldTypeDefaultsProvider defaultsProvider) {
        return this.indexRootBuilder.createTypeFactory(defaultsProvider);
    }

    @Override
    public IndexSchemaElement schemaElement() {
        return new IndexSchemaElementImpl<B>(this.createTypeFactory(), this.indexSchemaObjectNodeBuilder, this.nestingContext, this.isParentMultivaluedAndWithoutObjectField());
    }

    @Override
    public IndexSchemaElement schemaElement(IndexSchemaContributionListener listener) {
        return new IndexSchemaElementImpl<B>(this.createTypeFactory(), this.indexSchemaObjectNodeBuilder, new NotifyingNestingContext(this.nestingContext, listener), this.isParentMultivaluedAndWithoutObjectField());
    }

    @Override
    public Optional<IndexedEmbeddedBindingContext> addIndexedEmbeddedIfIncluded(IndexedEmbeddedDefinition definition, boolean multiValued) {
        IndexedEmbeddedPathTracker pathTracker = this.mapperContext.getOrCreatePathTracker(definition);
        return this.nestingContext.addIndexedEmbeddedIfIncluded(definition, pathTracker, new NestedContextBuilderImpl(this.mapperContext, this.indexRootBuilder, (IndexCompositeNodeBuilder)this.indexSchemaObjectNodeBuilder, definition, this.isParentMultivaluedAndWithoutObjectField() || multiValued));
    }

    abstract boolean isParentMultivaluedAndWithoutObjectField();

    private static class NestedContextBuilderImpl
    implements ConfiguredIndexSchemaNestingContext.NestedContextBuilder<IndexedEmbeddedBindingContext> {
        private final IndexedEntityBindingMapperContext mapperContext;
        private final IndexRootBuilder indexRootBuilder;
        private IndexCompositeNodeBuilder currentNodeBuilder;
        private final IndexedEmbeddedDefinition definition;
        private final List<IndexObjectFieldReference> parentIndexObjectReferences = new ArrayList<IndexObjectFieldReference>();
        private boolean multiValued;

        private NestedContextBuilderImpl(IndexedEntityBindingMapperContext mapperContext, IndexRootBuilder indexRootBuilder, IndexCompositeNodeBuilder currentNodeBuilder, IndexedEmbeddedDefinition definition, boolean multiValued) {
            this.mapperContext = mapperContext;
            this.indexRootBuilder = indexRootBuilder;
            this.currentNodeBuilder = currentNodeBuilder;
            this.definition = definition;
            this.multiValued = multiValued;
        }

        @Override
        public void appendObject(String objectName) {
            IndexObjectFieldBuilder nextNodeBuilder = this.currentNodeBuilder.addObjectField(objectName, IndexFieldInclusion.INCLUDED, this.definition.structure());
            if (this.multiValued) {
                this.multiValued = false;
                nextNodeBuilder.multiValued();
            }
            this.parentIndexObjectReferences.add(nextNodeBuilder.toReference());
            this.currentNodeBuilder = nextNodeBuilder;
        }

        @Override
        public IndexedEmbeddedBindingContext build(ConfiguredIndexSchemaNestingContext nestingContext) {
            return new IndexedEmbeddedBindingContextImpl(this.mapperContext, this.indexRootBuilder, this.currentNodeBuilder, this.parentIndexObjectReferences, nestingContext, this.multiValued);
        }
    }
}

