/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.cache.simple;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.Identifiable;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.scheduler.LinkedScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;

public class SimpleCache<K, V extends Identifiable<K>>
implements Cache<K, V>,
Predicate<K> {
    private final ConcurrentMap<K, Entry<V>> entries = new ConcurrentHashMap<K, Entry<V>>();
    private final StatefulObjectFactory<V> factory;
    private final Supplier<K> identifierFactory;
    private final Duration timeout;
    private final ServerEnvironment environment;
    private final Scheduler<K, Instant> scheduler = new LocalScheduler((ScheduledEntries)new LinkedScheduledEntries(), (Predicate)this, Duration.ZERO);

    public SimpleCache(StatefulObjectFactory<V> factory, Supplier<K> identifierFactory, StatefulTimeoutInfo timeout, ServerEnvironment environment) {
        this.factory = factory;
        this.identifierFactory = identifierFactory;
        this.timeout = timeout != null && timeout.getValue() >= 0L ? Duration.of(timeout.getValue(), timeout.getTimeUnit().toChronoUnit()) : null;
        this.environment = environment;
    }

    public void start() {
    }

    public void stop() {
        this.scheduler.close();
        for (Map.Entry entry : this.entries.entrySet()) {
            this.factory.destroyInstance((Identifiable)((Entry)entry.getValue()).getValue());
        }
        this.entries.clear();
    }

    public Affinity getStrictAffinity() {
        return new NodeAffinity(this.environment.getNodeName());
    }

    public Affinity getWeakAffinity(K key) {
        return Affinity.NONE;
    }

    @Override
    public Supplier<K> getIdentifierFactory() {
        return this.identifierFactory;
    }

    @Override
    public V create() {
        if (CURRENT_GROUP.get() != null) {
            throw EjbLogger.ROOT_LOGGER.incompatibleCaches();
        }
        Identifiable bean = (Identifiable)this.factory.createInstance();
        this.entries.put(bean.getId(), new Entry<Identifiable>(bean));
        return (V)bean;
    }

    @Override
    public void discard(V value) {
        this.entries.remove(value.getId());
    }

    @Override
    public void remove(K key) {
        Entry entry = (Entry)this.entries.remove(key);
        if (entry != null) {
            this.factory.destroyInstance((Identifiable)entry.getValue());
        }
    }

    @Override
    public V get(K key) {
        Entry entry = (Entry)this.entries.get(key);
        if (entry == null) {
            return null;
        }
        this.scheduler.cancel(key);
        entry.use();
        return (V)((Identifiable)entry.getValue());
    }

    @Override
    public boolean contains(K key) {
        return this.entries.containsKey(key);
    }

    @Override
    public void release(V bean) {
        Object id = bean.getId();
        Entry entry = (Entry)this.entries.get(id);
        if (entry != null && entry.done() && this.timeout != null) {
            if (!this.timeout.isZero()) {
                this.scheduler.schedule(id, (Object)Instant.now().plus(this.timeout));
            } else {
                this.remove(id);
            }
        }
    }

    @Override
    public int getCacheSize() {
        return this.entries.size();
    }

    @Override
    public int getPassivatedCount() {
        return 0;
    }

    @Override
    public int getTotalSize() {
        return this.getCacheSize();
    }

    @Override
    public boolean test(K key) {
        this.remove(key);
        return true;
    }

    static class Entry<V> {
        private final V value;
        private final AtomicInteger usage = new AtomicInteger();

        Entry(V value) {
            this.value = value;
        }

        void use() {
            this.usage.incrementAndGet();
        }

        boolean done() {
            return this.usage.decrementAndGet() == 0;
        }

        V getValue() {
            return this.value;
        }
    }
}

