/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.JoinChildrenIdIterator;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;

public abstract class JoiningLongMultiValuesSource
extends LongMultiValuesSource {
    protected final NestedDocsProvider nestedDocsProvider;

    public static JoiningLongMultiValuesSource fromLongField(String field, NestedDocsProvider nested) {
        return JoiningLongMultiValuesSource.fromField(field, nested);
    }

    public static JoiningLongMultiValuesSource fromIntField(String field, NestedDocsProvider nested) {
        return JoiningLongMultiValuesSource.fromField(field, nested);
    }

    private static JoiningLongMultiValuesSource fromField(String field, NestedDocsProvider nested) {
        return new FieldLongMultiValuesSource(field, nested);
    }

    public JoiningLongMultiValuesSource(NestedDocsProvider nestedDocsProvider) {
        this.nestedDocsProvider = nestedDocsProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoiningLongMultiValuesSource that = (JoiningLongMultiValuesSource)o;
        return Objects.equals(this.nestedDocsProvider, that.nestedDocsProvider);
    }

    public int hashCode() {
        return this.nestedDocsProvider.hashCode();
    }

    @Override
    public LongMultiValues getValues(LeafReaderContext ctx) throws IOException {
        SortedNumericDocValues values = this.getSortedNumericDocValues(ctx);
        if (this.nestedDocsProvider == null) {
            return LongMultiValues.fromDocValues(values);
        }
        BitSet rootDocs = this.nestedDocsProvider.parentDocs(ctx);
        DocIdSetIterator innerDocs = this.nestedDocsProvider.childDocs(ctx);
        return this.join(values, rootDocs, innerDocs);
    }

    protected abstract SortedNumericDocValues getSortedNumericDocValues(LeafReaderContext var1) throws IOException;

    protected LongMultiValues join(final SortedNumericDocValues values, BitSet parentDocs, DocIdSetIterator childDocs) {
        if (parentDocs == null || childDocs == null) {
            return LongMultiValues.EMPTY;
        }
        final JoinChildrenIdIterator joinIterator = new JoinChildrenIdIterator(parentDocs, childDocs, (DocIdSetIterator)values);
        return new LongMultiValues(){
            int currentParentDoc = -1;
            int remainingValuesForChild = 0;

            @Override
            public boolean advanceExact(int parentDoc) throws IOException {
                assert (parentDoc >= this.currentParentDoc) : "can only evaluate current and upcoming parent docs";
                if (parentDoc == this.currentParentDoc) {
                    return this.hasNextValue();
                }
                this.currentParentDoc = parentDoc;
                this.remainingValuesForChild = 0;
                return joinIterator.advanceExact(parentDoc);
            }

            @Override
            public boolean hasNextValue() throws IOException {
                if (this.remainingValuesForChild > 0) {
                    return true;
                }
                if (joinIterator.advanceValuesToNextChild()) {
                    this.remainingValuesForChild = values.docValueCount();
                    return true;
                }
                this.remainingValuesForChild = 0;
                return false;
            }

            @Override
            public long nextValue() throws IOException {
                --this.remainingValuesForChild;
                return values.nextValue();
            }
        };
    }

    private static class FieldLongMultiValuesSource
    extends JoiningLongMultiValuesSource {
        private final String field;

        public FieldLongMultiValuesSource(String field, NestedDocsProvider nestedDocsProvider) {
            super(nestedDocsProvider);
            this.field = field;
        }

        public String toString() {
            return "Long(" + this.field + "," + this.nestedDocsProvider + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            FieldLongMultiValuesSource that = (FieldLongMultiValuesSource)o;
            return Objects.equals(this.field, that.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field);
        }

        @Override
        protected SortedNumericDocValues getSortedNumericDocValues(LeafReaderContext ctx) throws IOException {
            return DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.field);
        }
    }
}

