/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.InstrumentationLibraryMarshaler;
import io.opentelemetry.exporter.internal.otlp.ResourceMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.InstrumentationLibrarySpansMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanMarshaler;
import io.opentelemetry.proto.trace.v1.internal.ResourceSpans;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ResourceSpansMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrlUtf8;
    private final InstrumentationLibrarySpansMarshaler[] instrumentationLibrarySpansMarshalers;

    public static ResourceSpansMarshaler[] create(Collection<SpanData> spanDataList) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<SpanMarshaler>>> resourceAndLibraryMap = ResourceSpansMarshaler.groupByResourceAndLibrary(spanDataList);
        ResourceSpansMarshaler[] resourceSpansMarshalers = new ResourceSpansMarshaler[resourceAndLibraryMap.size()];
        int posResource = 0;
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<SpanMarshaler>>> entry : resourceAndLibraryMap.entrySet()) {
            InstrumentationLibrarySpansMarshaler[] instrumentationLibrarySpansMarshalers = new InstrumentationLibrarySpansMarshaler[entry.getValue().size()];
            int posInstrumentation = 0;
            for (Map.Entry<InstrumentationLibraryInfo, List<SpanMarshaler>> entryIs : entry.getValue().entrySet()) {
                instrumentationLibrarySpansMarshalers[posInstrumentation++] = new InstrumentationLibrarySpansMarshaler(InstrumentationLibraryMarshaler.create(entryIs.getKey()), MarshalerUtil.toBytes(entryIs.getKey().getSchemaUrl()), entryIs.getValue());
            }
            resourceSpansMarshalers[posResource++] = new ResourceSpansMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes(entry.getKey().getSchemaUrl()), instrumentationLibrarySpansMarshalers);
        }
        return resourceSpansMarshalers;
    }

    ResourceSpansMarshaler(ResourceMarshaler resourceMarshaler, byte[] schemaUrlUtf8, InstrumentationLibrarySpansMarshaler[] instrumentationLibrarySpansMarshalers) {
        super(ResourceSpansMarshaler.calculateSize(resourceMarshaler, schemaUrlUtf8, instrumentationLibrarySpansMarshalers));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.instrumentationLibrarySpansMarshalers = instrumentationLibrarySpansMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ResourceSpans.RESOURCE, this.resourceMarshaler);
        output.serializeRepeatedMessage(ResourceSpans.INSTRUMENTATION_LIBRARY_SPANS, this.instrumentationLibrarySpansMarshalers);
        output.serializeString(ResourceSpans.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] schemaUrlUtf8, InstrumentationLibrarySpansMarshaler[] instrumentationLibrarySpansMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ResourceSpans.RESOURCE, resourceMarshaler);
        size += MarshalerUtil.sizeBytes(ResourceSpans.SCHEMA_URL, schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceSpans.INSTRUMENTATION_LIBRARY_SPANS, (Marshaler[])instrumentationLibrarySpansMarshalers);
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<SpanMarshaler>>> groupByResourceAndLibrary(Collection<SpanData> spanDataList) {
        return MarshalerUtil.groupByResourceAndLibrary(spanDataList, SpanData::getResource, SpanData::getInstrumentationLibraryInfo, SpanMarshaler::create);
    }
}

