/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.Before;
import org.junit.Test;

public class OneWayChainClusterTest
extends ClusterTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupServer(3, this.isFileStorage(), this.isNetty());
        this.setupServer(4, this.isFileStorage(), this.isNetty());
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testBasicRoundRobin() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(4, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
        this.verifyClusterMetrics(0, "cluster0-1", 5L, 5L);
        this.verifyClusterMetrics(1, "cluster1-2", 5L, 5L);
        this.verifyClusterMetrics(2, "cluster2-3", 5L, 5L);
        this.verifyClusterMetrics(3, "cluster3-4", 5L, 5L);
        this.verifyClusterMetrics(4, "cluster4-X", 0L, 0L);
    }

    @Test
    public void testBasicNonLoadBalanced() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(4, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(4, "queues.testaddress", "queue2", null, false);
        this.createQueue(4, "queues.testaddress", "queue3", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 0, "queue1", null);
        this.addConsumer(2, 4, "queue2", null);
        this.addConsumer(3, 4, "queue3", null);
        this.waitForBindings(0, "queues.testaddress", 2, 2, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0, 1, 2, 3);
        this.verifyNotReceive(0, 1, 2, 3);
    }

    @Test
    public void testRoundRobinForwardWhenNoConsumersTrue() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.STRICT, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.STRICT, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.STRICT, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.STRICT, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(4, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
    }

    @Test
    public void testRoundRobinForwardWhenNoConsumersFalseNoLocalQueue() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(4, this.isNetty(), true);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.addConsumer(1, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 1);
        this.verifyNotReceive(1);
    }

    @Test
    public void testRoundRobinForwardWhenNoConsumersFalse() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(4, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
    }

    @Test
    public void testRoundRobinForwardWhenNoConsumersFalseLocalConsumer() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(4, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.addConsumer(1, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.verifyReceiveAll(10, 0);
        this.verifyNotReceive(0, 1);
    }

    @Test
    public void testHopsTooLow() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 3, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.ON_DEMAND, 3, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.ON_DEMAND, 3, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.ON_DEMAND, 3, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(4, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 4, "queue0", null);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveAll(10, 0);
        this.verifyNotReceive(1);
    }

    @Test
    public void testStartStopMiddleOfChain() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(4, this.isNetty(), true);
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(4, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 4, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
        this.instanceLog.debug((Object)"============================================ before restart");
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[0]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[1]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[2]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[3]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[4]));
        this.stopServers(2);
        OneWayChainClusterTest.waitForTopology((ActiveMQServer)this.servers[1], (int)4);
        Thread.sleep(1000L);
        this.instanceLog.debug((Object)"============================================ after stop");
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[0]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[1]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[3]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[4]));
        this.startServers(2);
        Thread.sleep(1000L);
        OneWayChainClusterTest.waitForTopology((ActiveMQServer)this.servers[1], (int)5);
        this.instanceLog.debug((Object)"============================================ after start");
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[0]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[1]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[2]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[3]));
        this.instanceLog.debug((Object)this.clusterDescription(this.servers[4]));
        this.send(0, "queues.testaddress", 10, false, null);
        this.verifyReceiveRoundRobin(10, 0, 1);
        this.verifyNotReceive(0, 1);
    }

    @Test
    public void testChainClusterConnections() throws Exception {
        this.setupClusterConnection("cluster0-1", 0, 1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster1-2", 1, 2, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster2-3", 2, 3, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster3-4", 3, 4, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.setupClusterConnection("cluster4-X", 4, -1, "queues", MessageLoadBalancingType.ON_DEMAND, 4, this.isNetty(), true);
        this.startServers(0, 1, 2, 3, 4);
        Set connectionSet = this.getServer(0).getClusterManager().getClusterConnections();
        OneWayChainClusterTest.assertNotNull((Object)connectionSet);
        OneWayChainClusterTest.assertEquals((long)1L, (long)connectionSet.size());
        ClusterConnectionImpl ccon = (ClusterConnectionImpl)connectionSet.iterator().next();
        long timeout = System.currentTimeMillis() + 5000L;
        Map records = null;
        while (timeout > System.currentTimeMillis() && ((records = ccon.getRecords()) == null || records.size() != 1)) {
        }
        OneWayChainClusterTest.assertNotNull(records);
        OneWayChainClusterTest.assertEquals((long)records.size(), (long)1L);
        this.getServer(1).getClusterManager().getClusterConnections();
        OneWayChainClusterTest.assertNotNull((Object)connectionSet);
        OneWayChainClusterTest.assertEquals((long)1L, (long)connectionSet.size());
        ccon = (ClusterConnectionImpl)connectionSet.iterator().next();
        records = ccon.getRecords();
        OneWayChainClusterTest.assertNotNull((Object)records);
        OneWayChainClusterTest.assertEquals((long)records.size(), (long)1L);
        this.getServer(2).getClusterManager().getClusterConnections();
        OneWayChainClusterTest.assertNotNull((Object)connectionSet);
        OneWayChainClusterTest.assertEquals((long)1L, (long)connectionSet.size());
        ccon = (ClusterConnectionImpl)connectionSet.iterator().next();
        records = ccon.getRecords();
        OneWayChainClusterTest.assertNotNull((Object)records);
        OneWayChainClusterTest.assertEquals((long)records.size(), (long)1L);
        this.getServer(3).getClusterManager().getClusterConnections();
        OneWayChainClusterTest.assertNotNull((Object)connectionSet);
        OneWayChainClusterTest.assertEquals((long)1L, (long)connectionSet.size());
        ccon = (ClusterConnectionImpl)connectionSet.iterator().next();
        records = ccon.getRecords();
        OneWayChainClusterTest.assertNotNull((Object)records);
        OneWayChainClusterTest.assertEquals((long)records.size(), (long)1L);
        this.getServer(4).getClusterManager().getClusterConnections();
        OneWayChainClusterTest.assertNotNull((Object)connectionSet);
        OneWayChainClusterTest.assertEquals((long)1L, (long)connectionSet.size());
        ccon = (ClusterConnectionImpl)connectionSet.iterator().next();
        records = ccon.getRecords();
        OneWayChainClusterTest.assertNotNull((Object)records);
        OneWayChainClusterTest.assertEquals((long)records.size(), (long)1L);
    }
}

