/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.stomp.util.AbstractStompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RetryRule;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class StompTestBase
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(StompTestBase.class);
    @Parameterized.Parameter
    public String scheme;
    @Rule
    public RetryRule retryRule = new RetryRule(2);
    protected URI uri;
    protected String hostname = "127.0.0.1";
    protected final int port = 61613;
    private ConnectionFactory connectionFactory;
    protected Connection connection;
    protected Session session;
    protected Queue queue;
    protected Topic topic;
    protected ActiveMQServer server;
    protected String defUser = "brianm";
    protected String defPass = "wombats";

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v10.stomp"}, {"tcp+v10.stomp"});
    }

    public boolean isCompressLargeMessages() {
        return false;
    }

    public boolean isSecurityEnabled() {
        return false;
    }

    public boolean isPersistenceEnabled() {
        return false;
    }

    public boolean isEnableStompMessageId() {
        return false;
    }

    public Integer getStompMinLargeMessageSize() {
        return null;
    }

    public List<String> getIncomingInterceptors() {
        return null;
    }

    public List<String> getOutgoingInterceptors() {
        return null;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.uri = new URI(this.scheme + "://" + this.hostname + ":" + 61613);
        this.server = this.createServer();
        this.server.start();
        this.waitForServerToStart(this.server);
        this.connectionFactory = this.createConnectionFactory();
        ((ActiveMQConnectionFactory)this.connectionFactory).setCompressLargeMessage(this.isCompressLargeMessages());
        this.connection = this.isSecurityEnabled() ? this.connectionFactory.createConnection("brianm", "wombats") : this.connectionFactory.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.queue = this.session.createQueue(StompTestBase.getQueueName());
        this.topic = this.session.createTopic(StompTestBase.getTopicName());
        this.connection.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    @After
    public void tearDownConnections() {
        AbstractStompClientConnection.tearDownConnections();
    }

    protected ActiveMQServer createServer() throws Exception {
        String stompAcceptorURI = "tcp://localhost:61613?stompConsumerWindowSize=-1";
        if (this.isEnableStompMessageId()) {
            stompAcceptorURI = stompAcceptorURI + ";stompEnableMessageId=true";
        }
        if (this.getStompMinLargeMessageSize() != null) {
            stompAcceptorURI = stompAcceptorURI + ";stompMinLargeMessageSize=2048";
        }
        Configuration config = this.createBasicConfig().setSecurityEnabled(this.isSecurityEnabled()).setPersistenceEnabled(this.isPersistenceEnabled()).addAcceptorConfiguration("stomp", stompAcceptorURI).addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName())).setConnectionTtlCheckInterval(500L).addQueueConfiguration(new QueueConfiguration(StompTestBase.getQueueName()).setRoutingType(RoutingType.ANYCAST)).addAddressConfiguration(new CoreAddressConfiguration().setName(StompTestBase.getTopicName()).addRoutingType(RoutingType.MULTICAST));
        if (this.getIncomingInterceptors() != null) {
            config.setIncomingInterceptorClassNames(this.getIncomingInterceptors());
        }
        if (this.getOutgoingInterceptors() != null) {
            config.setOutgoingInterceptorClassNames(this.getOutgoingInterceptors());
        }
        config.setPersistenceEnabled(true);
        ActiveMQServer activeMQServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (String)this.defUser, (String)this.defPass));
        if (this.isSecurityEnabled()) {
            ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)activeMQServer.getSecurityManager();
            String role = "testRole";
            securityManager.getConfiguration().addRole(this.defUser, "testRole");
            config.getSecurityRoles().put("#", new HashSet<Role>(){
                {
                    this.add(new Role("testRole", true, true, true, true, true, true, true, true, true, true));
                }
            });
        }
        return activeMQServer;
    }

    protected ConnectionFactory createConnectionFactory() {
        return new ActiveMQJMSConnectionFactory(false, new TransportConfiguration[]{new TransportConfiguration(InVMConnectorFactory.class.getName())});
    }

    protected static String getQueueName() {
        return "testQueue";
    }

    protected static String getQueuePrefix() {
        return "";
    }

    protected static String getTopicName() {
        return "testtopic";
    }

    protected static String getTopicPrefix() {
        return "";
    }

    public void sendJmsMessage(String msg) throws Exception {
        this.sendJmsMessage(msg, (Destination)this.queue);
    }

    public void sendJmsMessage(String msg, Destination destination) throws Exception {
        MessageProducer producer = this.session.createProducer(destination);
        TextMessage message = this.session.createTextMessage(msg);
        producer.send((Message)message);
    }

    public void sendJmsMessage(byte[] data, Destination destination) throws Exception {
        this.sendJmsMessage(data, "foo", "xyz", destination);
    }

    public void sendJmsMessage(String msg, String propertyName, String propertyValue) throws Exception {
        this.sendJmsMessage(msg.getBytes(StandardCharsets.UTF_8), propertyName, propertyValue, (Destination)this.queue);
    }

    public void sendJmsMessage(byte[] data, String propertyName, String propertyValue, Destination destination) throws Exception {
        MessageProducer producer = this.session.createProducer(destination);
        BytesMessage message = this.session.createBytesMessage();
        message.setStringProperty(propertyName, propertyValue);
        message.writeBytes(data);
        producer.send((Message)message);
    }

    public static void abortTransaction(StompClientConnection conn, String txID) throws IOException, InterruptedException {
        ClientStompFrame abortFrame = conn.createFrame("ABORT").addHeader("transaction", txID);
        conn.sendFrame(abortFrame);
    }

    public static void beginTransaction(StompClientConnection conn, String txID) throws IOException, InterruptedException {
        ClientStompFrame beginFrame = conn.createFrame("BEGIN").addHeader("transaction", txID);
        conn.sendFrame(beginFrame);
    }

    public static void commitTransaction(StompClientConnection conn, String txID) throws IOException, InterruptedException {
        StompTestBase.commitTransaction(conn, txID, false);
    }

    public static void commitTransaction(StompClientConnection conn, String txID, boolean receipt) throws IOException, InterruptedException {
        ClientStompFrame beginFrame = conn.createFrame("COMMIT").addHeader("transaction", txID);
        String uuid = UUID.randomUUID().toString();
        if (receipt) {
            beginFrame.addHeader("receipt", uuid);
        }
        ClientStompFrame resp = conn.sendFrame(beginFrame);
        if (receipt) {
            StompTestBase.assertEquals((Object)uuid, (Object)resp.getHeader("receipt-id"));
        }
    }

    public static void ack(StompClientConnection conn, String subscriptionId, ClientStompFrame messageIdFrame) throws IOException, InterruptedException {
        ClientStompFrame response;
        String messageID = messageIdFrame.getHeader("message-id");
        ClientStompFrame frame = conn.createFrame("ACK").addHeader("message-id", messageID);
        if (subscriptionId != null) {
            frame.addHeader("subscription", subscriptionId);
        }
        if ((response = conn.sendFrame(frame)) != null) {
            throw new IOException("failed to ack " + response);
        }
    }

    public static void ack(StompClientConnection conn, String subscriptionId, String mid, String txID) throws IOException, InterruptedException {
        ClientStompFrame frame = conn.createFrame("ACK").addHeader("subscription", subscriptionId).addHeader("message-id", mid);
        if (txID != null) {
            frame.addHeader("transaction", txID);
        }
        conn.sendFrame(frame);
    }

    public static void nack(StompClientConnection conn, String subscriptionId, String messageId) throws IOException, InterruptedException {
        ClientStompFrame frame = conn.createFrame("NACK").addHeader("subscription", subscriptionId).addHeader("message-id", messageId);
        conn.sendFrame(frame);
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subscriptionId, "auto");
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId, String ack) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subscriptionId, ack, null);
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId, String ack, String durableId) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subscriptionId, ack, durableId, true);
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId, String ack, String durableId, boolean receipt) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subscriptionId, ack, durableId, null, receipt);
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId, String ack, String durableId, String selector) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subscriptionId, ack, durableId, selector, true);
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId, String ack, String durableId, String selector, boolean receipt) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subscriptionId, ack, durableId, selector, StompTestBase.getQueuePrefix() + StompTestBase.getQueueName(), receipt);
    }

    public static ClientStompFrame subscribeQueue(StompClientConnection conn, String subId, String destination) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subId, "auto", null, null, destination, true);
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId, String ack, String durableId, String selector, String destination, boolean receipt) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subscriptionId, ack, durableId, selector, destination, receipt, null);
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId, String ack, String durableId, String selector, String destination, boolean receipt, Integer consumerWindowSize) throws IOException, InterruptedException {
        return StompTestBase.subscribe(conn, subscriptionId, ack, durableId, selector, destination, receipt, consumerWindowSize, "consumer-window-size");
    }

    public static ClientStompFrame subscribe(StompClientConnection conn, String subscriptionId, String ack, String durableId, String selector, String destination, boolean receipt, Integer consumerWindowSize, String consumerWindowSizeHeader) throws IOException, InterruptedException {
        ClientStompFrame frame = conn.createFrame("SUBSCRIBE").addHeader("subscription-type", RoutingType.ANYCAST.toString()).addHeader("destination", destination);
        if (subscriptionId != null) {
            frame.addHeader("id", subscriptionId);
        }
        if (ack != null) {
            frame.addHeader("ack", ack);
        }
        if (durableId != null) {
            frame.addHeader("durable-subscription-name", durableId);
        }
        if (selector != null) {
            frame.addHeader("selector", selector);
        }
        if (consumerWindowSize != null) {
            frame.addHeader(consumerWindowSizeHeader, consumerWindowSize.toString());
        }
        String uuid = UUID.randomUUID().toString();
        if (receipt) {
            frame.addHeader("receipt", uuid);
        }
        if ((frame = conn.sendFrame(frame)) != null && frame.getCommand().equals("ERROR")) {
            return frame;
        }
        if (receipt) {
            StompTestBase.assertEquals((Object)uuid, (Object)frame.getHeader("receipt-id"));
        }
        return frame;
    }

    public static ClientStompFrame subscribeTopic(StompClientConnection conn, String subscriptionId, String ack, String durableId) throws IOException, InterruptedException {
        return StompTestBase.subscribeTopic(conn, subscriptionId, ack, durableId, true);
    }

    public static ClientStompFrame subscribeTopic(StompClientConnection conn, String subscriptionId, String ack, String durableId, boolean receipt) throws IOException, InterruptedException {
        return StompTestBase.subscribeTopic(conn, subscriptionId, ack, durableId, receipt, false);
    }

    public static ClientStompFrame subscribeTopic(StompClientConnection conn, String subscriptionId, String ack, String durableId, boolean receipt, boolean noLocal) throws IOException, InterruptedException {
        return StompTestBase.subscribeTopic(conn, subscriptionId, ack, durableId, "durable-subscription-name", receipt, noLocal);
    }

    public static ClientStompFrame subscribeTopicLegacyActiveMQ(StompClientConnection conn, String subscriptionId, String ack, String durableId, boolean receipt, boolean noLocal) throws IOException, InterruptedException {
        return StompTestBase.subscribeTopic(conn, subscriptionId, ack, durableId, "activemq.subscriptionName", receipt, noLocal);
    }

    public static ClientStompFrame subscribeTopic(StompClientConnection conn, String subscriptionId, String ack, String durableId, String durableIdHeader, boolean receipt, boolean noLocal) throws IOException, InterruptedException {
        ClientStompFrame frame = conn.createFrame("SUBSCRIBE").addHeader("subscription-type", RoutingType.MULTICAST.toString()).addHeader("destination", StompTestBase.getTopicPrefix() + StompTestBase.getTopicName());
        if (subscriptionId != null) {
            frame.addHeader("id", subscriptionId);
        }
        if (ack != null) {
            frame.addHeader("ack", ack);
        }
        if (durableId != null) {
            frame.addHeader(durableIdHeader, durableId);
        }
        String uuid = UUID.randomUUID().toString();
        if (receipt) {
            frame.addHeader("receipt", uuid);
        }
        if (noLocal) {
            frame.addHeader("no-local", "true");
        }
        if ((frame = conn.sendFrame(frame)).getCommand().equals("ERROR")) {
            return frame;
        }
        if (receipt) {
            StompTestBase.assertNotNull((String)"Requested receipt, but response is null", (Object)frame);
            StompTestBase.assertTrue((boolean)frame.getHeader("receipt-id").equals(uuid));
        }
        return frame;
    }

    public static ClientStompFrame unsubscribe(StompClientConnection conn, String subscriptionId) throws IOException, InterruptedException {
        return StompTestBase.unsubscribe(conn, subscriptionId, null, false, false);
    }

    public static ClientStompFrame unsubscribe(StompClientConnection conn, String subscriptionId, boolean receipt) throws IOException, InterruptedException {
        return StompTestBase.unsubscribe(conn, subscriptionId, null, receipt, false);
    }

    public static ClientStompFrame unsubscribe(StompClientConnection conn, String subscriptionId, String destination, boolean receipt, boolean durable) throws IOException, InterruptedException {
        return StompTestBase.unsubscribe(conn, subscriptionId, "durable-subscription-name", destination, receipt, durable);
    }

    public static ClientStompFrame unsubscribeLegacyActiveMQ(StompClientConnection conn, String subscriptionId, String destination, boolean receipt, boolean durable) throws IOException, InterruptedException {
        return StompTestBase.unsubscribe(conn, subscriptionId, "activemq.subscriptionName", destination, receipt, durable);
    }

    public static ClientStompFrame unsubscribe(StompClientConnection conn, String subscriptionId, String subscriptionIdHeader, String destination, boolean receipt, boolean durable) throws IOException, InterruptedException {
        ClientStompFrame frame = conn.createFrame("UNSUBSCRIBE");
        if (durable && subscriptionId != null) {
            frame.addHeader(subscriptionIdHeader, subscriptionId);
        } else if (!durable && subscriptionId != null) {
            frame.addHeader("id", subscriptionId);
        }
        if (destination != null) {
            frame.addHeader("destination", destination);
        }
        String uuid = UUID.randomUUID().toString();
        if (receipt) {
            frame.addHeader("receipt", uuid);
        }
        frame = conn.sendFrame(frame);
        if (receipt) {
            StompTestBase.assertEquals((Object)"RECEIPT", (Object)frame.getCommand());
            StompTestBase.assertEquals((Object)uuid, (Object)frame.getHeader("receipt-id"));
        }
        return frame;
    }

    public static ClientStompFrame send(StompClientConnection conn, String destination, String contentType, String body) throws IOException, InterruptedException {
        return StompTestBase.send(conn, destination, contentType, body, false);
    }

    public static ClientStompFrame send(StompClientConnection conn, String destination, String contentType, String body, boolean receipt) throws IOException, InterruptedException {
        return StompTestBase.send(conn, destination, contentType, body, receipt, null);
    }

    public static ClientStompFrame send(StompClientConnection conn, String destination, String contentType, String body, boolean receipt, RoutingType destinationType) throws IOException, InterruptedException {
        return StompTestBase.send(conn, destination, contentType, body, receipt, destinationType, null);
    }

    public static ClientStompFrame send(StompClientConnection conn, String destination, String contentType, String body, boolean receipt, RoutingType destinationType, String txId) throws IOException, InterruptedException {
        ClientStompFrame frame = conn.createFrame("SEND").addHeader("destination", destination).setBody(body);
        if (contentType != null) {
            frame.addHeader("content-type", contentType);
        }
        if (destinationType != null) {
            frame.addHeader("destination-type", destinationType.toString());
        }
        if (txId != null) {
            frame.addHeader("transaction", txId);
        }
        String uuid = UUID.randomUUID().toString();
        if (receipt) {
            frame.addHeader("receipt", uuid);
        }
        if ((frame = conn.sendFrame(frame)) != null && frame.getCommand().equals("ERROR")) {
            return frame;
        }
        if (receipt) {
            StompTestBase.assertEquals((Object)"RECEIPT", (Object)frame.getCommand());
            StompTestBase.assertEquals((Object)uuid, (Object)frame.getHeader("receipt-id"));
        }
        log.debug((Object)("Received: " + frame));
        return frame;
    }

    public static URI createStompClientUri(String scheme, String hostname, int port) throws URISyntaxException {
        return new URI(scheme + "://" + hostname + ":" + port);
    }
}

