/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.convert;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.convert.MessageFactory;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeConverter
implements Converter,
PartialStateHolder {
    public static final String CONVERTER_ID = "jakarta.faces.DateTime";
    public static final String DATE_ID = "jakarta.faces.converter.DateTimeConverter.DATE";
    public static final String TIME_ID = "jakarta.faces.converter.DateTimeConverter.TIME";
    public static final String DATETIME_ID = "jakarta.faces.converter.DateTimeConverter.DATETIME";
    public static final String STRING_ID = "jakarta.faces.converter.STRING";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private String dateStyle = "default";
    private Locale locale;
    private String pattern;
    private String timeStyle = "default";
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private String type = "date";
    private boolean transientFlag;
    private boolean initialState;

    public String getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(String dateStyle) {
        this.clearInitialState();
        this.dateStyle = dateStyle;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(FacesContext.getCurrentInstance());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.clearInitialState();
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.clearInitialState();
        this.pattern = pattern;
    }

    public String getTimeStyle() {
        return this.timeStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.clearInitialState();
        this.timeStyle = timeStyle;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.clearInitialState();
        this.timeZone = timeZone;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.clearInitialState();
        this.type = type;
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Object returnValue = null;
        FormatWrapper parser = null;
        try {
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() < 1) {
                return null;
            }
            Locale locale = this.getLocale(context);
            parser = this.getDateFormat(locale);
            if (this.timeZone != null) {
                parser.setTimeZone(this.timeZone);
            }
            returnValue = parser.parse(value);
        }
        catch (ParseException | DateTimeParseException e) {
            if (this.type != null) {
                switch (this.type) {
                    case "date": 
                    case "localDate": {
                        throw new ConverterException(MessageFactory.getMessage(context, DATE_ID, value, parser.formatNow(), MessageFactory.getLabel(context, component)), (Throwable)e);
                    }
                    case "time": 
                    case "localTime": 
                    case "offsetTime": {
                        throw new ConverterException(MessageFactory.getMessage(context, TIME_ID, value, parser.formatNow(), MessageFactory.getLabel(context, component)), (Throwable)e);
                    }
                    case "both": 
                    case "localDateTime": 
                    case "offsetDateTime": 
                    case "zonedDateTime": {
                        throw new ConverterException(MessageFactory.getMessage(context, DATETIME_ID, value, parser.formatNow(), MessageFactory.getLabel(context, component)), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
        return returnValue;
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        try {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Locale locale = this.getLocale(context);
            FormatWrapper formatter = this.getDateFormat(locale);
            if (null != this.timeZone) {
                formatter.setTimeZone(this.timeZone);
            }
            return formatter.format(value);
        }
        catch (ConverterException e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConverterException(MessageFactory.getMessage(context, STRING_ID, value, MessageFactory.getLabel(context, component)), (Throwable)e);
        }
    }

    private FormatWrapper getDateFormat(Locale locale) {
        if (this.pattern == null && this.type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        DateFormat df = null;
        DateTimeFormatter dtf = null;
        TemporalQuery<Object> from = null;
        if (this.pattern != null && !DateTimeConverter.isJavaTimeType(this.type)) {
            df = new SimpleDateFormat(this.pattern, locale);
        } else if (this.type.equals("both")) {
            df = DateFormat.getDateTimeInstance(DateTimeConverter.getStyle(this.dateStyle), DateTimeConverter.getStyle(this.timeStyle), locale);
        } else if (this.type.equals("date")) {
            df = DateFormat.getDateInstance(DateTimeConverter.getStyle(this.dateStyle), locale);
        } else if (this.type.equals("time")) {
            df = DateFormat.getTimeInstance(DateTimeConverter.getStyle(this.timeStyle), locale);
        } else if (this.type.equals("localDate")) {
            dtf = null != this.pattern ? DateTimeFormatter.ofPattern(this.pattern, locale) : DateTimeFormatter.ofLocalizedDate(DateTimeConverter.getFormatStyle(this.dateStyle)).withLocale(locale);
            from = LocalDate::from;
        } else if (this.type.equals("localDateTime")) {
            dtf = null != this.pattern ? DateTimeFormatter.ofPattern(this.pattern, locale) : DateTimeFormatter.ofLocalizedDateTime(DateTimeConverter.getFormatStyle(this.dateStyle), DateTimeConverter.getFormatStyle(this.timeStyle)).withLocale(locale);
            from = LocalDateTime::from;
        } else if (this.type.equals("localTime")) {
            dtf = null != this.pattern ? DateTimeFormatter.ofPattern(this.pattern, locale) : DateTimeFormatter.ofLocalizedTime(DateTimeConverter.getFormatStyle(this.timeStyle)).withLocale(locale);
            from = LocalTime::from;
        } else if (this.type.equals("offsetTime")) {
            dtf = null != this.pattern ? DateTimeFormatter.ofPattern(this.pattern, locale) : DateTimeFormatter.ISO_OFFSET_TIME.withLocale(locale);
            from = OffsetTime::from;
        } else if (this.type.equals("offsetDateTime")) {
            dtf = null != this.pattern ? DateTimeFormatter.ofPattern(this.pattern, locale) : DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(locale);
            from = OffsetDateTime::from;
        } else if (this.type.equals("zonedDateTime")) {
            dtf = null != this.pattern ? DateTimeFormatter.ofPattern(this.pattern, locale) : DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(locale);
            from = ZonedDateTime::from;
        } else {
            throw new IllegalArgumentException("Invalid type: " + this.type);
        }
        if (null != df) {
            df.setLenient(false);
            return new FormatWrapper(df);
        }
        if (null != dtf) {
            return new FormatWrapper(dtf, from);
        }
        throw new IllegalArgumentException("Invalid type: " + this.type);
    }

    private static boolean isJavaTimeType(String type) {
        boolean result = false;
        if (null != type && type.length() > 1) {
            char c = type.charAt(0);
            result = c == 'l' || c == 'o' || c == 'z';
        }
        return result;
    }

    private Locale getLocale(FacesContext context) {
        Locale locale = this.locale;
        if (locale == null) {
            locale = context.getViewRoot().getLocale();
        }
        return locale;
    }

    private static int getStyle(String name) {
        if (null != name) {
            switch (name) {
                case "default": {
                    return 2;
                }
                case "short": {
                    return 3;
                }
                case "medium": {
                    return 2;
                }
                case "long": {
                    return 1;
                }
                case "full": {
                    return 0;
                }
            }
        }
        throw new ConverterException("Invalid style '" + name + "'");
    }

    private static FormatStyle getFormatStyle(String name) {
        if (null != name) {
            switch (name) {
                case "default": 
                case "medium": {
                    return FormatStyle.MEDIUM;
                }
                case "short": {
                    return FormatStyle.SHORT;
                }
                case "long": {
                    return FormatStyle.LONG;
                }
                case "full": {
                    return FormatStyle.FULL;
                }
            }
        }
        throw new ConverterException("Invalid style '" + name + "'");
    }

    @Override
    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.dateStyle, this.locale, this.pattern, this.timeStyle, this.timeZone, this.type};
            return values;
        }
        return null;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.dateStyle = (String)values[0];
            this.locale = (Locale)values[1];
            this.pattern = (String)values[2];
            this.timeStyle = (String)values[3];
            this.timeZone = (TimeZone)values[4];
            this.type = (String)values[5];
        }
    }

    @Override
    public boolean isTransient() {
        return this.transientFlag;
    }

    @Override
    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    @Override
    public void markInitialState() {
        this.initialState = true;
    }

    @Override
    public boolean initialStateMarked() {
        return this.initialState;
    }

    @Override
    public void clearInitialState() {
        this.initialState = false;
    }

    private static class FormatWrapper {
        private final DateFormat dateFormat;
        private final DateTimeFormatter dateTimeFormatter;
        private final TemporalQuery<Object> from;

        private FormatWrapper(DateFormat dataFormat) {
            this.dateFormat = dataFormat;
            this.dateTimeFormatter = null;
            this.from = null;
        }

        private FormatWrapper(DateTimeFormatter dateTimeFormatter, TemporalQuery<Object> from) {
            this.dateFormat = null;
            this.dateTimeFormatter = dateTimeFormatter;
            this.from = from;
        }

        private Object parse(CharSequence text) throws ParseException {
            return this.dateFormat != null ? this.dateFormat.parse((String)text) : this.dateTimeFormatter.parse(text, this.from);
        }

        private String format(Object obj) {
            return this.dateFormat != null ? this.dateFormat.format(obj) : this.dateTimeFormatter.format((TemporalAccessor)obj);
        }

        private String formatNow() {
            return this.dateFormat != null ? this.dateFormat.format(new Date()) : this.dateTimeFormatter.format(ZonedDateTime.now());
        }

        private void setTimeZone(TimeZone zone) {
            if (this.dateFormat != null) {
                this.dateFormat.setTimeZone(zone);
            }
        }
    }
}

