/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.util.XMLChar;

public abstract class TypeValidator {
    private static final boolean USE_CODE_POINT_COUNT_FOR_STRING_LENGTH = AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            try {
                return Boolean.getBoolean("org.apache.xerces.impl.dv.xs.useCodePointCountForStringLength") ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (SecurityException securityException) {
                return Boolean.FALSE;
            }
        }
    }) == Boolean.TRUE;
    public static final short LESS_THAN = -1;
    public static final short EQUAL = 0;
    public static final short GREATER_THAN = 1;
    public static final short INDETERMINATE = 2;

    public abstract short getAllowedFacets();

    public abstract Object getActualValue(String var1, ValidationContext var2) throws InvalidDatatypeValueException;

    public void checkExtraRules(Object value, ValidationContext context) throws InvalidDatatypeValueException {
    }

    public boolean isIdentical(Object value1, Object value2) {
        return value1.equals(value2);
    }

    public int compare(Object value1, Object value2) {
        return -1;
    }

    public int getDataLength(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            if (!USE_CODE_POINT_COUNT_FOR_STRING_LENGTH) {
                return str.length();
            }
            return this.getCodePointLength(str);
        }
        return -1;
    }

    public int getTotalDigits(Object value) {
        return -1;
    }

    public int getFractionDigits(Object value) {
        return -1;
    }

    private int getCodePointLength(String value) {
        int len = value.length();
        int surrogatePairCount = 0;
        for (int i = 0; i < len - 1; ++i) {
            if (!XMLChar.isHighSurrogate(value.charAt(i))) continue;
            if (XMLChar.isLowSurrogate(value.charAt(++i))) {
                ++surrogatePairCount;
                continue;
            }
            --i;
        }
        return len - surrogatePairCount;
    }

    public static final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static final int getDigit(char ch) {
        return TypeValidator.isDigit(ch) ? ch - 48 : -1;
    }
}

