/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.wildfly.common.Assert;

public abstract class PermittedCandidates
implements DefaultCompleter.CandidatesProvider {
    public static PermittedCandidates create(String value, AccessRequirement requirement) {
        StaticPermittedCandidates provider = new StaticPermittedCandidates();
        return provider.add(value, requirement);
    }

    protected abstract List<ValueWithAccessRequirement> getValues(CommandContext var1);

    protected abstract void add(ValueWithAccessRequirement var1);

    public PermittedCandidates add(String value, AccessRequirement requirement) {
        this.add(new ValueWithAccessRequirement(value, requirement));
        return this;
    }

    @Override
    public Collection<String> getAllCandidates(CommandContext ctx) {
        ArrayList<String> allowed = new ArrayList<String>();
        if (ctx.getConfig().isAccessControl()) {
            for (ValueWithAccessRequirement value : this.getValues(ctx)) {
                value.visit(ctx, allowed);
            }
        } else {
            for (ValueWithAccessRequirement value : this.getValues(ctx)) {
                allowed.add(value.value);
            }
        }
        return allowed;
    }

    private static class StaticPermittedCandidates
    extends PermittedCandidates {
        private final List<ValueWithAccessRequirement> values = new ArrayList<ValueWithAccessRequirement>();

        private StaticPermittedCandidates() {
        }

        @Override
        protected List<ValueWithAccessRequirement> getValues(CommandContext ctx) {
            return this.values;
        }

        @Override
        protected void add(ValueWithAccessRequirement value) {
            this.values.add(value);
        }
    }

    public static class ValueWithAccessRequirement {
        private final String value;
        private final AccessRequirement requirement;

        public ValueWithAccessRequirement(String value, AccessRequirement requirement) {
            this.value = (String)Assert.checkNotNullParam((String)"value", (Object)value);
            this.requirement = (AccessRequirement)Assert.checkNotNullParam((String)"requirement", (Object)requirement);
        }

        void visit(CommandContext ctx, List<String> allowed) {
            if (this.requirement.isSatisfied(ctx)) {
                allowed.add(this.value);
            }
        }
    }
}

