/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.impl.AbstractContext;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class WorkerContext
extends ContextImpl {
    private Executor executor;

    WorkerContext(VertxInternal vertx, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, CloseFuture closeFuture, ClassLoader tccl, boolean disableTCCL) {
        super(vertx, vertx.getEventLoopGroup().next(), internalBlockingPool, workerPool, deployment, closeFuture, tccl, disableTCCL);
    }

    @Override
    void runOnContext(AbstractContext ctx, Handler<Void> action) {
        try {
            this.run(ctx, null, action);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    <T> void execute(AbstractContext ctx, T argument, Handler<T> task) {
        this.execute(this.orderedTasks, argument, task);
    }

    @Override
    <T> void emit(AbstractContext ctx, T argument, Handler<T> task) {
        this.execute(this.orderedTasks, argument, (T arg) -> ctx.dispatch(arg, task));
    }

    @Override
    <T> void execute(AbstractContext ctx, Runnable task) {
        this.execute(this, task, Runnable::run);
    }

    @Override
    public boolean isEventLoopContext() {
        return false;
    }

    @Override
    public Executor executor() {
        if (this.executor == null) {
            this.executor = command -> {
                PoolMetrics metrics = this.workerPool.metrics();
                Object queueMetric = metrics != null ? metrics.submitted() : null;
                this.orderedTasks.execute(() -> {
                    Object execMetric = null;
                    if (metrics != null) {
                        execMetric = metrics.begin(queueMetric);
                    }
                    try {
                        command.run();
                    }
                    finally {
                        if (metrics != null) {
                            metrics.end(execMetric, true);
                        }
                    }
                }, this.workerPool.executor());
            };
        }
        return this.executor;
    }

    private <T> void run(ContextInternal ctx, T value, Handler<T> task) {
        Objects.requireNonNull(task, "Task handler must not be null");
        this.executor().execute(() -> ctx.dispatch(value, task));
    }

    private <T> void execute(TaskQueue queue, T argument, Handler<T> task) {
        if (Context.isOnWorkerThread()) {
            task.handle(argument);
        } else {
            PoolMetrics metrics = this.workerPool.metrics();
            Object queueMetric = metrics != null ? metrics.submitted() : null;
            queue.execute(() -> {
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                try {
                    task.handle(argument);
                }
                finally {
                    if (metrics != null) {
                        metrics.end(execMetric, true);
                    }
                }
            }, this.workerPool.executor());
        }
    }

    @Override
    boolean inThread() {
        return Context.isOnWorkerThread();
    }
}

