/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GetInDoubtTransactionsCommand
extends BaseRpcCommand {
    private static final Log log = LogFactory.getLog(GetInDoubtTransactionsCommand.class);
    public static final int COMMAND_ID = 21;

    private GetInDoubtTransactionsCommand() {
        super(null);
    }

    public GetInDoubtTransactionsCommand(ByteString cacheName) {
        super(cacheName);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        RecoveryManager recoveryManager = componentRegistry.getRecoveryManager().running();
        List<XidImpl> localInDoubtTransactions = recoveryManager.getInDoubtTransactions();
        log.tracef("Returning result %s", localInDoubtTransactions);
        return CompletableFuture.completedFuture(localInDoubtTransactions);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public byte getCommandId() {
        return 21;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " { cacheName = " + this.cacheName + "}";
    }
}

