/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.elytron;

import java.io.IOException;
import java.security.Principal;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.cache.CachedIdentity;

public class CachedIdentityMarshaller
implements ProtoStreamMarshaller<CachedIdentity> {
    private static final int MECHANISM_INDEX = 1;
    private static final int NON_PROGRAMMIC_NAME_INDEX = 2;
    private static final int PROGRAMMATIC_NAME_INDEX = 3;
    private static final int ROLE_INDEX = 4;
    private static final String DEFAULT_MECHANISM = "FORM";

    public CachedIdentity readFrom(ProtoStreamReader reader) throws IOException {
        String mechanism = DEFAULT_MECHANISM;
        String name = null;
        boolean programmatic = false;
        LinkedList<String> roles = new LinkedList<String>();
        block6: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    mechanism = reader.readString();
                    continue block6;
                }
                case 3: {
                    programmatic = true;
                }
                case 2: {
                    name = reader.readString();
                    continue block6;
                }
                case 4: {
                    roles.add(reader.readString());
                    continue block6;
                }
            }
            reader.skipField(tag);
        }
        return new CachedIdentity(mechanism, programmatic, (Principal)new NamePrincipal(name), CachedIdentityMarshaller.toSet(roles));
    }

    private static Set<String> toSet(List<String> roles) {
        switch (roles.size()) {
            case 0: {
                return Set.of();
            }
            case 1: {
                return Set.of(roles.get(0));
            }
        }
        return Set.of((String[])roles.toArray(String[]::new));
    }

    public void writeTo(ProtoStreamWriter writer, CachedIdentity identity) throws IOException {
        String name;
        String mechanism = identity.getMechanismName();
        if (!mechanism.equals(DEFAULT_MECHANISM)) {
            writer.writeString(1, mechanism);
        }
        if ((name = identity.getName()) != null) {
            writer.writeString(identity.isProgrammatic() ? 3 : 2, name);
        }
        for (String role : identity.getRoles()) {
            writer.writeString(4, role);
        }
    }

    public Class<? extends CachedIdentity> getJavaClass() {
        return CachedIdentity.class;
    }
}

