/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.PutIndexAliasesWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class PutIndexAliasesWork
extends AbstractNonBulkableWork<Void> {
    protected PutIndexAliasesWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder>
    implements PutIndexAliasesWorkBuilder {
        private final JsonObject payload;

        public Builder(GsonProvider gsonProvider, URLEncodedString indexName, Map<String, IndexAliasDefinition> aliases) {
            super(DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.payload = Builder.createPayload(gsonProvider, indexName.original, aliases);
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(Paths._ALIASES).body(this.payload);
            return builder.build();
        }

        @Override
        public PutIndexAliasesWork build() {
            return new PutIndexAliasesWork(this);
        }

        private static JsonObject createPayload(GsonProvider gsonProvider, String indexName, Map<String, IndexAliasDefinition> aliases) {
            Gson gson = gsonProvider.getGsonNoSerializeNulls();
            JsonObject payload = new JsonObject();
            JsonArray actions = new JsonArray();
            payload.add("actions", (JsonElement)actions);
            for (Map.Entry<String, IndexAliasDefinition> entry : aliases.entrySet()) {
                JsonObject action = new JsonObject();
                JsonObject aliasDefinition = gson.toJsonTree((Object)entry.getValue()).getAsJsonObject();
                action.add("add", (JsonElement)aliasDefinition);
                aliasDefinition.addProperty("index", indexName);
                aliasDefinition.addProperty("alias", entry.getKey());
                actions.add((JsonElement)action);
            }
            return payload;
        }
    }
}

