/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmDerivedRoot;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public abstract class AbstractSqmSelectQuery<T>
extends AbstractSqmNode
implements SqmSelectQuery<T>,
SqmCteContainer {
    private final Map<String, SqmCteStatement<?>> cteStatements;
    private boolean withRecursive;
    private SqmQueryPart<T> sqmQueryPart;
    private Class<T> resultType;

    public AbstractSqmSelectQuery(Class<T> resultType, NodeBuilder builder) {
        this(new SqmQuerySpec(builder), resultType, builder);
    }

    public AbstractSqmSelectQuery(SqmQueryPart<T> queryPart, Class<T> resultType, NodeBuilder builder) {
        super(builder);
        this.cteStatements = new LinkedHashMap();
        this.resultType = resultType;
        this.setQueryPart(queryPart);
    }

    protected AbstractSqmSelectQuery(NodeBuilder builder, Map<String, SqmCteStatement<?>> cteStatements, boolean withRecursive, Class<T> resultType) {
        super(builder);
        this.cteStatements = cteStatements;
        this.withRecursive = withRecursive;
        this.resultType = resultType;
    }

    protected Map<String, SqmCteStatement<?>> copyCteStatements(SqmCopyContext context) {
        LinkedHashMap cteStatements = new LinkedHashMap(this.cteStatements.size());
        for (Map.Entry<String, SqmCteStatement<?>> entry : this.cteStatements.entrySet()) {
            cteStatements.put(entry.getKey(), (SqmCteStatement<?>)entry.getValue().copy(context));
        }
        return cteStatements;
    }

    @Override
    public boolean isWithRecursive() {
        return this.withRecursive;
    }

    @Override
    public void setWithRecursive(boolean withRecursive) {
        this.withRecursive = withRecursive;
    }

    @Override
    public Collection<SqmCteStatement<?>> getCteStatements() {
        return this.cteStatements.values();
    }

    @Override
    public SqmCteStatement<?> getCteStatement(String cteLabel) {
        return this.cteStatements.get(cteLabel);
    }

    @Override
    public void addCteStatement(SqmCteStatement<?> cteStatement) {
        if (this.cteStatements.putIfAbsent(cteStatement.getCteTable().getCteName(), cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getCteName() + " already exists");
        }
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    protected void setResultType(Class<T> resultType) {
        this.resultType = resultType;
    }

    @Override
    public SqmQuerySpec<T> getQuerySpec() {
        return this.sqmQueryPart.getFirstQuerySpec();
    }

    @Override
    public SqmQueryPart<T> getQueryPart() {
        return this.sqmQueryPart;
    }

    public void setQueryPart(SqmQueryPart<T> sqmQueryPart) {
        this.sqmQueryPart = sqmQueryPart;
    }

    public Set<Root<?>> getRoots() {
        return ((SqmQuerySpec)this.getQuerySpec()).getRoots();
    }

    @Override
    public <X> SqmRoot<X> from(Class<X> entityClass) {
        return this.addRoot(new SqmRoot(this.nodeBuilder().getDomainModel().entity((Class)entityClass), null, true, this.nodeBuilder()));
    }

    @Override
    public <X> SqmDerivedRoot<X> from(Subquery<X> subquery) {
        return this.from((Subquery)subquery, false);
    }

    @Override
    public <X> SqmDerivedRoot<X> fromLateral(Subquery<X> subquery) {
        return this.from((Subquery)subquery, true);
    }

    @Override
    public <X> SqmDerivedRoot<X> from(Subquery<X> subquery, boolean lateral) {
        this.validateComplianceFromSubQuery();
        SqmDerivedRoot root = new SqmDerivedRoot((SqmSubQuery)subquery, null, lateral);
        this.addRoot(root);
        return root;
    }

    private <X> SqmRoot<X> addRoot(SqmRoot<X> root) {
        ((SqmQuerySpec)this.getQuerySpec()).addRoot(root);
        return root;
    }

    @Override
    public <X> SqmRoot<X> from(EntityType<X> entityType) {
        return this.addRoot(new SqmRoot((EntityDomainType)entityType, null, true, this.nodeBuilder()));
    }

    private void validateComplianceFromSubQuery() {
        if (this.nodeBuilder().getDomainModel().getJpaCompliance().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support subqueries in the from clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    public boolean isDistinct() {
        return ((SqmQuerySpec)this.getQuerySpec()).isDistinct();
    }

    @Override
    public SqmSelectQuery<T> distinct(boolean distinct) {
        ((SqmQuerySpec)this.getQuerySpec()).setDistinct(distinct);
        return this;
    }

    @Override
    public JpaSelection<T> getSelection() {
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection();
    }

    @Override
    public SqmPredicate getRestriction() {
        return ((SqmQuerySpec)this.getQuerySpec()).getRestriction();
    }

    @Override
    public SqmSelectQuery<T> where(Expression<Boolean> restriction) {
        ((SqmQuerySpec)this.getQuerySpec()).setRestriction((Expression)restriction);
        return this;
    }

    @Override
    public SqmSelectQuery<T> where(Predicate ... restrictions) {
        ((SqmQuerySpec)this.getQuerySpec()).setRestriction(restrictions);
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return ((SqmQuerySpec)this.getQuerySpec()).getGroupingExpressions();
    }

    @Override
    public SqmSelectQuery<T> groupBy(Expression<?> ... expressions) {
        return this.groupBy((List)Arrays.asList(expressions));
    }

    @Override
    public SqmSelectQuery<T> groupBy(List<Expression<?>> grouping) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupingExpressions(grouping);
        return this;
    }

    @Override
    public SqmPredicate getGroupRestriction() {
        return ((SqmQuerySpec)this.getQuerySpec()).getGroupRestriction();
    }

    @Override
    public SqmSelectQuery<T> having(Expression<Boolean> booleanExpression) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupRestriction(this.nodeBuilder().wrap((Expression)booleanExpression));
        return this;
    }

    @Override
    public SqmSelectQuery<T> having(Predicate ... predicates) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupRestriction(this.nodeBuilder().wrap((Expression[])predicates));
        return this;
    }

    public void appendHqlString(StringBuilder sb) {
        if (!this.cteStatements.isEmpty()) {
            sb.append("with ");
            if (this.withRecursive) {
                sb.append("recursive ");
            }
            for (SqmCteStatement<?> value : this.cteStatements.values()) {
                value.appendHqlString(sb);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        this.sqmQueryPart.appendHqlString(sb);
    }
}

