/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl.parser.mappers;

import java.util.List;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.parser.mappers.Mapper;
import org.infinispan.protostream.impl.parser.mappers.Mappers;
import protostream.com.squareup.protoparser.EnumElement;
import protostream.com.squareup.protoparser.MessageElement;
import protostream.com.squareup.protoparser.ProtoFile;

public final class ProtofileMapper
implements Mapper<ProtoFile, FileDescriptor> {
    @Override
    public FileDescriptor map(ProtoFile protoFile) {
        List<MessageElement> messageTypes = Mappers.filter(protoFile.typeElements(), MessageElement.class);
        List<EnumElement> enumTypes = Mappers.filter(protoFile.typeElements(), EnumElement.class);
        return new FileDescriptor.Builder().withSyntax(this.map(protoFile.syntax())).withName(protoFile.filePath()).withPackageName(protoFile.packageName()).withMessageTypes(Mappers.MESSAGE_LIST_MAPPER.map(messageTypes)).withEnumTypes(Mappers.ENUM_LIST_MAPPER.map(enumTypes)).withExtendDescriptors(Mappers.EXTEND_LIST_MAPPER.map(protoFile.extendDeclarations())).withOptions(Mappers.OPTION_LIST_MAPPER.map(protoFile.options())).withDependencies(protoFile.dependencies()).withPublicDependencies(protoFile.publicDependencies()).build();
    }

    @Override
    private FileDescriptor.Syntax map(ProtoFile.Syntax syntax) {
        if (syntax == null) {
            return null;
        }
        if (syntax == ProtoFile.Syntax.PROTO_2) {
            return FileDescriptor.Syntax.PROTO2;
        }
        if (syntax == ProtoFile.Syntax.PROTO_3) {
            return FileDescriptor.Syntax.PROTO3;
        }
        throw new IllegalArgumentException("Unexpected syntax : " + syntax);
    }
}

