/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.io.IOException;
import java.util.function.Consumer;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.jmx.JmxMicrometerCollector;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

class MicrometerRegistryService
implements Service {
    private final Consumer<WildFlyRegistry> registriesConsumer;
    private WildFlyRegistry registry;

    static void install(OperationContext context, boolean securityEnabled) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName());
        serviceBuilder.setInstance((Service)new MicrometerRegistryService(serviceBuilder.provides(new ServiceName[]{MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName()}))).install();
    }

    private MicrometerRegistryService(Consumer<WildFlyRegistry> registriesConsumer) {
        this.registriesConsumer = registriesConsumer;
    }

    public void start(StartContext context) {
        this.registry = new WildFlyRegistry();
        try {
            new JmxMicrometerCollector(this.registry).init();
        }
        catch (IOException e) {
            throw MicrometerExtensionLogger.MICROMETER_LOGGER.failedInitializeJMXRegistrar(e);
        }
        this.registriesConsumer.accept(this.registry);
    }

    public void stop(StopContext context) {
    }
}

