/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.util.List;
import java.util.function.Function;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.micrometer.MicrometerCollectorService;
import org.wildfly.extension.micrometer.MicrometerContextService;
import org.wildfly.extension.micrometer.MicrometerDependencyProcessor;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerRegistryService;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.deployment.MicrometerSubsystemDeploymentProcessor;
import org.wildfly.extension.micrometer.metrics.MicrometerCollector;

public class MicrometerSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    public static final MicrometerSubsystemAdd INSTANCE = new MicrometerSubsystemAdd();

    MicrometerSubsystemAdd() {
        super(MicrometerSubsystemDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (!context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.metrics.scan")) {
            final List exposedSubsystems = MicrometerSubsystemDefinition.EXPOSED_SUBSYSTEMS.unwrap((ExpressionResolver)context, model);
            final boolean exposeAnySubsystem = exposedSubsystems.remove("*");
            boolean securityEnabled = MicrometerSubsystemDefinition.SECURITY_ENABLED.resolveModelAttribute(context, model).asBoolean();
            MicrometerRegistryService.install(context, securityEnabled);
            MicrometerCollectorService.install(context);
            MicrometerContextService.install(context, securityEnabled);
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                public void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor("micrometer", Phase.DEPENDENCIES, 6416, (DeploymentUnitProcessor)new MicrometerDependencyProcessor());
                    processorTarget.addDeploymentProcessor("micrometer", Phase.POST_MODULE, 14164, (DeploymentUnitProcessor)new MicrometerSubsystemDeploymentProcessor(exposeAnySubsystem, exposedSubsystems));
                }
            }, OperationContext.Stage.RUNTIME);
            context.addStep((operationContext, modelNode) -> {
                ServiceController serviceController = context.getServiceRegistry(false).getService(MicrometerSubsystemDefinition.MICROMETER_COLLECTOR);
                MicrometerCollector micrometerCollector = (MicrometerCollector)MicrometerCollector.class.cast(serviceController.getValue());
                ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
                Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
                micrometerCollector.collectResourceMetrics(rootResource, rootResourceRegistration, Function.identity(), exposeAnySubsystem, exposedSubsystems);
            }, OperationContext.Stage.VERIFY);
        }
        MicrometerExtensionLogger.MICROMETER_LOGGER.activatingSubsystem();
    }
}

