/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.resource.definition;

import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.concurrent.ContextServiceImpl;
import org.jboss.as.ee.concurrent.ContextServiceTypesConfiguration;
import org.jboss.as.ee.concurrent.DefaultContextSetupProviderImpl;
import org.jboss.as.ee.concurrent.service.ContextServiceService;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.ee.subsystem.ContextServiceResourceDefinition;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.Service;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class ContextServiceDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    private final ContextServiceTypesConfiguration contextServiceTypesConfiguration;

    public ContextServiceDefinitionInjectionSource(String jndiName, ContextServiceTypesConfiguration contextServiceTypesConfiguration) {
        super(jndiName);
        this.contextServiceTypesConfiguration = contextServiceTypesConfiguration;
    }

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, final Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        String resourceName = this.uniqueName(context);
        String resourceJndiName = "java:jboss/ee/concurrency/definition/context/" + resourceName;
        try {
            ContextServiceService resourceService = new ContextServiceService(resourceName, resourceJndiName, new DefaultContextSetupProviderImpl(), this.contextServiceTypesConfiguration);
            ServiceName resourceServiceName = ContextServiceResourceDefinition.CAPABILITY.getCapabilityServiceName(new String[]{resourceName});
            phaseContext.getServiceTarget().addService(resourceServiceName).setInstance((Service)resourceService).install();
            serviceBuilder.addDependency(resourceServiceName, ContextServiceImpl.class, (Injector)new Injector<ContextServiceImpl>(){

                public void inject(final ContextServiceImpl resource) throws InjectionException {
                    injector.inject(() -> new ManagedReference(){

                        public void release() {
                        }

                        public Object getInstance() {
                            return resource;
                        }
                    });
                }

                public void uninject() {
                    injector.uninject();
                }
            });
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    public ContextServiceTypesConfiguration getContextServiceTypesConfiguration() {
        return this.contextServiceTypesConfiguration;
    }
}

