/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@NonNullApi
@NonNullFields
public class BaseOperatingSystemAdditionalMetrics
implements MeterBinder {
    private static final Log log = LogFactory.getLog(BaseOperatingSystemAdditionalMetrics.class);
    private static final OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method processCpuLoadMethod;
    private static final Method processCpuTimeMethod;

    public void bindTo(MeterRegistry registry) {
        Gauge.builder((String)"cpu.availableProcessors", (Object)operatingSystemBean, OperatingSystemMXBean::getAvailableProcessors).description("Displays the number of processors available to the Java virtual machine. This value may change during a particular invocation of the virtual machine.").register(registry);
        Gauge.builder((String)"cpu.systemLoadAverage", (Object)operatingSystemBean, OperatingSystemMXBean::getSystemLoadAverage).description("Displays the system load average for the last minute. The system load average is the sum of the number of runnable entities queued to the available processors and the number of runnable entities running on the available processors averaged over a period of time. The way in which the load average is calculated is operating system specific but is typically a damped time-dependent average. If the load average is not available, a negative value is displayed. This attribute is designed to provide a hint about the system load and may be queried frequently. The load average might be unavailable on some platforms where it is expensive to implement this method.").register(registry);
        if (processCpuLoadMethod != null) {
            Gauge.builder((String)"cpu.processCpuLoad", () -> this.invoke(processCpuLoadMethod)).description("Displays the \"recent cpu usage\" for the Java virtual machine process.").register(registry);
        }
        if (processCpuTimeMethod != null) {
            Gauge.builder((String)"cpu.processCpuTime", () -> this.invoke(processCpuTimeMethod)).description("Displays the CPU time, in nanoseconds, used by the process on which the Java virtual machine is running.").register(registry);
        }
    }

    private static Class<?> getOperatingSystemMXBeanImpl() {
        List<String> classNames = Arrays.asList("com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean");
        for (String className : classNames) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private static Method detectMethod(Class<?> operatingSystemBeanClass, String name) {
        if (operatingSystemBeanClass == null) {
            return null;
        }
        try {
            operatingSystemBeanClass.cast(operatingSystemBean);
            return operatingSystemBeanClass.getDeclaredMethod(name, new Class[0]);
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private double invoke(Method method) {
        try {
            Object returnedValue = method.invoke((Object)operatingSystemBean, new Object[0]);
            if (returnedValue instanceof Long) {
                return ((Long)returnedValue).doubleValue();
            }
            return (Double)returnedValue;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.warn("An error occurred while invoking method %1$1.", method, e);
            return -1.0;
        }
    }

    static {
        Class<?> operatingSystemBeanClass = BaseOperatingSystemAdditionalMetrics.getOperatingSystemMXBeanImpl();
        processCpuLoadMethod = BaseOperatingSystemAdditionalMetrics.detectMethod(operatingSystemBeanClass, "getProcessCpuLoad");
        processCpuTimeMethod = BaseOperatingSystemAdditionalMetrics.detectMethod(operatingSystemBeanClass, "getProcessCpuTime");
    }
}

