/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerCloseTest
extends ActiveMQTestBase {
    private ClientSessionFactory sf;
    private ActiveMQServer server;
    private ClientSession session;
    private SimpleString queue;
    private SimpleString address;
    private ServerLocator locator;

    @Test
    public void testCanNotUseAClosedConsumer() throws Exception {
        final ClientConsumer consumer = this.session.createConsumer(this.queue);
        consumer.close();
        Assert.assertTrue((boolean)consumer.isClosed());
        ConsumerCloseTest.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                consumer.receive();
            }
        });
        ConsumerCloseTest.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                consumer.receiveImmediate();
            }
        });
        ConsumerCloseTest.expectActiveMQException((ActiveMQExceptionType)ActiveMQExceptionType.OBJECT_CLOSED, (ActiveMQTestBase.ActiveMQAction)new ActiveMQTestBase.ActiveMQAction(){

            public void run() throws ActiveMQException {
                consumer.setMessageHandler(new MessageHandler(){

                    public void onMessage(ClientMessage message) {
                    }
                });
            }
        });
    }

    @Test
    public void testCloseWithManyMessagesInBufferAndSlowConsumer() throws Exception {
        ClientConsumer consumer = this.session.createConsumer(this.queue);
        ClientProducer producer = this.session.createProducer(this.address);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.session.createMessage(false);
            producer.send((Message)message);
        }
        final CountDownLatch received = new CountDownLatch(1);
        final CountDownLatch waitingToProceed = new CountDownLatch(1);
        class MyHandler
        implements MessageHandler {
            MyHandler() {
            }

            public void onMessage(ClientMessage message) {
                try {
                    received.countDown();
                    waitingToProceed.await();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        consumer.setMessageHandler((MessageHandler)new MyHandler());
        this.session.start();
        ConsumerCloseTest.assertTrue((boolean)received.await(5L, TimeUnit.SECONDS));
        long timeout = System.currentTimeMillis() + 1000L;
        while (((ClientConsumerImpl)consumer).getBufferSize() < 2 && System.currentTimeMillis() > timeout) {
            Thread.sleep(10L);
        }
        waitingToProceed.countDown();
        long start = System.currentTimeMillis();
        consumer.close();
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start <= 1500L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testCloseWithScheduledRedelivery() throws Exception {
        AddressSettings settings = new AddressSettings().setRedeliveryDelay(50000L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        ClientConsumer consumer = this.session.createConsumer(this.queue);
        ClientProducer producer = this.session.createProducer(this.address);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.session.createMessage(false);
            producer.send((Message)message);
        }
        this.session.start();
        ClientMessage msg = consumer.receive(5000L);
        msg.acknowledge();
        long timeout = System.currentTimeMillis() + 1000L;
        while (((ClientConsumerImpl)consumer).getBufferSize() < 2 && System.currentTimeMillis() > timeout) {
            Thread.sleep(10L);
        }
        consumer.close();
        consumer = this.session.createConsumer(this.queue);
        for (int i = 0; i < 99; ++i) {
            msg = consumer.receive(1000L);
            ConsumerCloseTest.assertNotNull((String)("Expected message at i=" + i), (Object)msg);
            msg.acknowledge();
        }
        ConsumerCloseTest.assertNull((Object)consumer.receiveImmediate());
        long start = System.currentTimeMillis();
        consumer.close();
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start <= 1500L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testCloseWithScheduledRedeliveryWithTX() throws Exception {
        AddressSettings settings = new AddressSettings().setRedeliveryDelay(1000L);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        ClientProducer producer = this.session.createProducer(this.address);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.session.createMessage(false);
            message.putIntProperty("count", i);
            producer.send((Message)message);
        }
        this.session.close();
        this.session = this.addClientSession(this.sf.createSession(false, false));
        ClientConsumer consumer = this.session.createConsumer(this.queue);
        this.session.start();
        ClientMessage msg = consumer.receive(500L);
        msg.acknowledge();
        long timeout = System.currentTimeMillis() + 1000L;
        while (((ClientConsumerImpl)consumer).getBufferSize() < 2 && System.currentTimeMillis() > timeout) {
            Thread.sleep(10L);
        }
        consumer.close();
        this.session.rollback();
        consumer = this.session.createConsumer(this.queue);
        for (int i = 0; i < 99; ++i) {
            msg = consumer.receive(1000L);
            ConsumerCloseTest.assertNotNull((String)("Expected message at i=" + i), (Object)msg);
            msg.acknowledge();
        }
        ConsumerCloseTest.assertNull((Object)consumer.receiveImmediate());
        msg = consumer.receive(5000L);
        ConsumerCloseTest.assertNotNull((Object)msg);
        ConsumerCloseTest.assertEquals((long)0L, (long)msg.getIntProperty("count").intValue());
        msg.acknowledge();
        this.session.commit();
        ConsumerCloseTest.assertNull((Object)consumer.receiveImmediate());
        long start = System.currentTimeMillis();
        consumer.close();
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start <= 1500L ? (byte)1 : 0) != 0);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultInVMConfig();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        this.server.start();
        this.address = RandomUtil.randomSimpleString();
        this.queue = RandomUtil.randomSimpleString();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
        this.session.createQueue(new QueueConfiguration(this.queue).setAddress(this.address).setDurable(Boolean.valueOf(false)));
    }
}

