/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenWireGroupingTest
extends BasicOpenWireTest {
    private boolean coreSend;
    private boolean coreReceive;

    @Parameterized.Parameters(name="core-send={0} core-receive={1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    public OpenWireGroupingTest(boolean coreSend, boolean coreReceive) {
        this.coreSend = coreSend;
        this.coreReceive = coreReceive;
    }

    @Test
    public void testGrouping() throws Exception {
        Queue queue;
        Session session;
        String jmsxgroupID = null;
        ConnectionFactory sendFact = this.coreSend ? this.coreCf : this.factory;
        ConnectionFactory receiveFact = this.coreReceive ? this.coreCf : this.factory;
        int num = 10;
        try (Connection coreConn = sendFact.createConnection();){
            session = coreConn.createSession(false, 2);
            queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int j = 0; j < 10; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                this.setProperty((Message)message);
                producer.send((Message)message);
                String prop = message.getStringProperty("JMSXGroupID");
                OpenWireGroupingTest.assertNotNull((Object)prop);
                if (jmsxgroupID != null) {
                    OpenWireGroupingTest.assertEquals((Object)jmsxgroupID, (Object)prop);
                    continue;
                }
                jmsxgroupID = prop;
            }
        }
        var6_6 = null;
        try (Connection connection = receiveFact.createConnection();){
            session = connection.createSession(false, 2);
            queue = session.createQueue(this.queueName);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue);
            connection.start();
            ArrayList<MessageConsumer> otherConsumers = new ArrayList<MessageConsumer>();
            otherConsumers.add(consumer1);
            otherConsumers.add(consumer2);
            otherConsumers.add(consumer3);
            MessageConsumer groupConsumer = null;
            for (MessageConsumer consumer : otherConsumers) {
                TextMessage tm = (TextMessage)consumer.receive(2000L);
                if (tm == null) continue;
                OpenWireGroupingTest.assertEquals((Object)"Message0", (Object)tm.getText());
                otherConsumers.remove(consumer);
                groupConsumer = consumer;
                break;
            }
            OpenWireGroupingTest.assertNotNull(groupConsumer);
            for (int j = 1; j < 10; ++j) {
                TextMessage tm = (TextMessage)groupConsumer.receive(2000L);
                OpenWireGroupingTest.assertNotNull((Object)tm);
                OpenWireGroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
                OpenWireGroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)jmsxgroupID);
            }
            for (MessageConsumer consumer : otherConsumers) {
                OpenWireGroupingTest.assertNull((Object)consumer.receive(100L));
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    protected void setProperty(Message message) {
        if (this.coreSend) {
            ((ActiveMQMessage)message).getCoreMessage().putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, new SimpleString("foo"));
        } else {
            org.apache.activemq.command.ActiveMQMessage m = (org.apache.activemq.command.ActiveMQMessage)message;
            m.setGroupID("foo");
        }
    }
}

