/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionCounterImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PagingCounterTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServerLocator sl;

    @Before
    public void checkLoggerStart() throws Exception {
        AssertionLoggerHandler.startCapture();
    }

    @After
    public void checkLoggerEnd() throws Exception {
        try {
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"222214"}));
            Assert.assertFalse((boolean)AssertionLoggerHandler.findText((String[])new String[]{"222215"}));
        }
        finally {
            AssertionLoggerHandler.stopCapture();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCounter() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.sl);
        ClientSession session = sf.createSession();
        try {
            this.server.addAddressInfo(new AddressInfo(new SimpleString("A1"), RoutingType.ANYCAST));
            Queue queue = this.server.createQueue(new QueueConfiguration(new SimpleString("A1")).setRoutingType(RoutingType.ANYCAST));
            PageSubscriptionCounter counter = this.locateCounter(queue);
            StorageManager storage = this.server.getStorageManager();
            TransactionImpl tx = new TransactionImpl(this.server.getStorageManager());
            counter.increment((Transaction)tx, 1, 1000L);
            PagingCounterTest.assertEquals((long)0L, (long)counter.getValue());
            PagingCounterTest.assertEquals((long)0L, (long)counter.getPersistentSize());
            tx.commit();
            storage.waitOnOperations();
            PagingCounterTest.assertEquals((long)1L, (long)counter.getValue());
            PagingCounterTest.assertEquals((long)1000L, (long)counter.getPersistentSize());
        }
        finally {
            sf.close();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanupCounter() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.sl);
        ClientSession session = sf.createSession();
        try {
            this.server.addAddressInfo(new AddressInfo(new SimpleString("A1"), RoutingType.ANYCAST));
            Queue queue = this.server.createQueue(new QueueConfiguration(new SimpleString("A1")).setRoutingType(RoutingType.ANYCAST));
            PageSubscriptionCounter counter = this.locateCounter(queue);
            StorageManager storage = this.server.getStorageManager();
            TransactionImpl tx = new TransactionImpl(this.server.getStorageManager());
            for (int i = 0; i < 2100; ++i) {
                counter.increment((Transaction)tx, 1, 1000L);
                if (i % 200 != 0) continue;
                tx.commit();
                storage.waitOnOperations();
                PagingCounterTest.assertEquals((long)(i + 1), (long)counter.getValue());
                PagingCounterTest.assertEquals((long)((i + 1) * 1000), (long)counter.getPersistentSize());
                tx = new TransactionImpl(this.server.getStorageManager());
            }
            tx.commit();
            storage.waitOnOperations();
            PagingCounterTest.assertEquals((long)2100L, (long)counter.getValue());
            PagingCounterTest.assertEquals((long)0x200B20L, (long)counter.getPersistentSize());
            this.server.stop();
            this.server = this.newActiveMQServer();
            this.server.start();
            queue = this.server.locateQueue(new SimpleString("A1"));
            PagingCounterTest.assertNotNull((Object)queue);
            counter = this.locateCounter(queue);
            PagingCounterTest.assertEquals((long)2100L, (long)counter.getValue());
            PagingCounterTest.assertEquals((long)0x200B20L, (long)counter.getPersistentSize());
        }
        finally {
            sf.close();
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanupCounterNonPersistent() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.sl);
        ClientSession session = sf.createSession();
        try {
            this.server.addAddressInfo(new AddressInfo(new SimpleString("A1"), RoutingType.ANYCAST));
            Queue queue = this.server.createQueue(new QueueConfiguration(new SimpleString("A1")).setRoutingType(RoutingType.ANYCAST));
            PageSubscriptionCounter counter = this.locateCounter(queue);
            ((PageSubscriptionCounterImpl)counter).setPersistent(false);
            StorageManager storage = this.server.getStorageManager();
            TransactionImpl tx = new TransactionImpl(this.server.getStorageManager());
            for (int i = 0; i < 2100; ++i) {
                counter.increment((Transaction)tx, 1, 1000L);
                if (i % 200 != 0) continue;
                tx.commit();
                storage.waitOnOperations();
                PagingCounterTest.assertEquals((long)(i + 1), (long)counter.getValue());
                PagingCounterTest.assertEquals((long)((i + 1) * 1000), (long)counter.getPersistentSize());
                tx = new TransactionImpl(this.server.getStorageManager());
            }
            tx.commit();
            storage.waitOnOperations();
            PagingCounterTest.assertEquals((long)2100L, (long)counter.getValue());
            PagingCounterTest.assertEquals((long)0x200B20L, (long)counter.getPersistentSize());
            this.server.stop();
            this.server = this.newActiveMQServer();
            this.server.start();
            queue = this.server.locateQueue(new SimpleString("A1"));
            PagingCounterTest.assertNotNull((Object)queue);
            counter = this.locateCounter(queue);
            PagingCounterTest.assertEquals((long)0L, (long)counter.getValue());
            PagingCounterTest.assertEquals((long)0L, (long)counter.getPersistentSize());
        }
        finally {
            sf.close();
            session.close();
        }
    }

    @Test
    public void testRestartCounter() throws Exception {
        this.server.addAddressInfo(new AddressInfo(new SimpleString("A1"), RoutingType.ANYCAST));
        Queue queue = this.server.createQueue(new QueueConfiguration(new SimpleString("A1")).setRoutingType(RoutingType.ANYCAST));
        PageSubscriptionCounter counter = this.locateCounter(queue);
        StorageManager storage = this.server.getStorageManager();
        TransactionImpl tx = new TransactionImpl(this.server.getStorageManager());
        counter.increment((Transaction)tx, 1, 1000L);
        PagingCounterTest.assertEquals((long)0L, (long)counter.getValue());
        PagingCounterTest.assertEquals((long)0L, (long)counter.getPersistentSize());
        tx.commit();
        storage.waitOnOperations();
        PagingCounterTest.assertEquals((long)1L, (long)counter.getValue());
        PagingCounterTest.assertEquals((long)1000L, (long)counter.getPersistentSize());
        this.sl.close();
        this.server.stop();
        this.server = this.newActiveMQServer();
        this.server.start();
        queue = this.server.locateQueue(new SimpleString("A1"));
        PagingCounterTest.assertNotNull((Object)queue);
        counter = this.locateCounter(queue);
        PagingCounterTest.assertEquals((long)1L, (long)counter.getValue());
        PagingCounterTest.assertEquals((long)1000L, (long)counter.getPersistentSize());
    }

    private PageSubscriptionCounter locateCounter(Queue queue) throws Exception {
        PageSubscription subscription = this.server.getPagingManager().getPageStore(new SimpleString("A1")).getCursorProvider().getSubscription(queue.getID().longValue());
        PageSubscriptionCounter counter = subscription.getCounter();
        return counter;
    }

    @Test
    public void testPrepareCounter() throws Exception {
        XidImpl xid = this.newXID();
        Queue queue = this.server.createQueue(new QueueConfiguration(new SimpleString("A1")).setRoutingType(RoutingType.ANYCAST));
        PageSubscriptionCounter counter = this.locateCounter(queue);
        StorageManager storage = this.server.getStorageManager();
        TransactionImpl tx = new TransactionImpl((Xid)xid, this.server.getStorageManager(), 300);
        for (int i = 0; i < 2000; ++i) {
            counter.increment((Transaction)tx, 1, 1000L);
        }
        PagingCounterTest.assertEquals((long)0L, (long)counter.getValue());
        tx.prepare();
        storage.waitOnOperations();
        PagingCounterTest.assertEquals((long)0L, (long)counter.getValue());
        this.server.stop();
        this.server = this.newActiveMQServer();
        this.server.start();
        storage = this.server.getStorageManager();
        queue = this.server.locateQueue(new SimpleString("A1"));
        PagingCounterTest.assertNotNull((Object)queue);
        counter = this.locateCounter(queue);
        tx = this.server.getResourceManager().removeTransaction((Xid)xid, null);
        PagingCounterTest.assertNotNull((Object)tx);
        PagingCounterTest.assertEquals((long)0L, (long)counter.getValue());
        tx.commit(false);
        storage.waitOnOperations();
        PagingCounterTest.assertEquals((long)2000L, (long)counter.getValue());
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.newActiveMQServer();
        this.server.start();
        this.sl = this.createInVMNonHALocator();
    }

    private ActiveMQServer newActiveMQServer() throws Exception {
        OperationContextImpl.clearContext();
        ActiveMQServer server = super.createServer(true, false);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        return server;
    }
}

