/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.util.MessageTracker;
import org.wildfly.naming.client.MarshallingCompatibilityHelper;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.AggregateObjectResolver;
import org.wildfly.naming.client.remote.EENamespaceInteroperability;
import org.wildfly.naming.client.remote.ProtocolUtils;
import org.wildfly.naming.client.remote.RemoteServerTransport;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class RemoteNamingService {
    static final int JAVAEE_PROTOCOL_VERSION = 2;
    static final int JAKARTAEE_PROTOCOL_VERSION = 3;
    static final int LATEST_VERSION;
    private static final int[] SUPPORTED_PROTOCOL_VERSIONS;
    private final Context localContext;
    private Registration registration;
    private final Function<String, Boolean> classResolverFilter;

    public RemoteNamingService(Context localContext) {
        this(localContext, null);
    }

    public RemoteNamingService(Context localContext, Function<String, Boolean> classResolverFilter) {
        this.localContext = localContext;
        this.classResolverFilter = classResolverFilter;
    }

    public void start(Endpoint endpoint) throws IOException {
        this.registration = endpoint.registerService("naming", new ChannelOpenListener(), OptionMap.EMPTY);
    }

    public void stop() throws IOException {
        this.registration.close();
    }

    public Context getLocalContext() {
        return this.localContext;
    }

    static {
        int[] nArray;
        int n = LATEST_VERSION = EENamespaceInteroperability.JAKARTAEE_ENVIRONMENT ? 3 : 2;
        if (LATEST_VERSION == 3) {
            int[] nArray2 = new int[3];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray = nArray2;
            nArray2[2] = 3;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 1;
            nArray = nArray3;
            nArray3[1] = 2;
        }
        SUPPORTED_PROTOCOL_VERSIONS = nArray;
    }

    private class ChannelOpenListener
    implements OpenListener {
        private ChannelOpenListener() {
        }

        @Override
        public void channelOpened(Channel channel) {
            final MessageTracker messageTracker = new MessageTracker(channel, channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES));
            try {
                channel.receiveMessage(new Channel.Receiver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleMessage(Channel channel, MessageInputStream message) {
                        try (MessageInputStream mis = message;){
                            byte[] namingHeader = new byte[6];
                            mis.read(namingHeader);
                            if (!Arrays.equals(namingHeader, ProtocolUtils.NAMING_BYTES)) {
                                throw Messages.log.invalidHeader();
                            }
                            int version = Math.min(LATEST_VERSION, mis.readUnsignedByte());
                            boolean versionSupported = false;
                            for (int supportedProtocolVersion : SUPPORTED_PROTOCOL_VERSIONS) {
                                if (version != supportedProtocolVersion) continue;
                                versionSupported = true;
                                break;
                            }
                            if (!versionSupported) {
                                throw Messages.log.unsupportedProtocolVersion(version);
                            }
                            Context localContext = null;
                            RemoteNamingService remoteNamingService = RemoteNamingService.this;
                            synchronized (remoteNamingService) {
                                try {
                                    localContext = (Context)RemoteNamingService.this.getLocalContext().lookup("");
                                }
                                catch (NamingException e) {
                                    Messages.log.unexpectedError(e);
                                }
                            }
                            RemoteServerTransport remoteServerTransport = new RemoteServerTransport(channel, version, messageTracker, localContext, RemoteNamingService.this.classResolverFilter);
                            List<MarshallingCompatibilityHelper> helpers = ProtocolUtils.getMarshallingCompatibilityHelpers();
                            ObjectResolver resolver = null;
                            for (MarshallingCompatibilityHelper helper : helpers) {
                                ObjectResolver nextResolver = helper.getObjectResolver(remoteServerTransport, false);
                                if (resolver == null) {
                                    resolver = nextResolver;
                                    continue;
                                }
                                if (resolver instanceof AggregateObjectResolver) {
                                    ((AggregateObjectResolver)resolver).add(nextResolver);
                                    continue;
                                }
                                resolver = new AggregateObjectResolver().add(nextResolver);
                            }
                            if (resolver != null) {
                                remoteServerTransport.getConfiguration().setObjectResolver(resolver);
                            }
                            remoteServerTransport.start();
                        }
                        catch (IOException | CommunicationException e) {
                            Messages.log.failedToDetermineClientVersion(e);
                        }
                    }

                    @Override
                    public void handleError(Channel channel, IOException error) {
                        try {
                            channel.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void handleEnd(Channel channel) {
                        try {
                            channel.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                try (MessageOutputStream mos = messageTracker.openMessage();){
                    mos.write(ProtocolUtils.NAMING_BYTES);
                    mos.writeByte(SUPPORTED_PROTOCOL_VERSIONS.length);
                    for (int version : SUPPORTED_PROTOCOL_VERSIONS) {
                        mos.writeByte(version > 1 ? version | 0x80 : version);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    IoUtils.safeClose((Closeable)channel);
                }
            }
            catch (IOException e) {
                Messages.log.failedToSendHeader(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }

        @Override
        public void registrationTerminated() {
        }
    }
}

