/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.logging;

import java.io.Serializable;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class JGroupsLogger_$logger
extends DelegatingBasicLogger
implements JGroupsLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JGroupsLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public JGroupsLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void activatingSubsystem(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.activatingSubsystem$str(), (Object)version);
    }

    protected String activatingSubsystem$str() {
        return "WFLYCLJG0001: Activating JGroups subsystem. JGroups version %s";
    }

    protected String parserFailure$str() {
        return "WFLYCLJG0007: Failed to parse %s";
    }

    @Override
    public final String parserFailure(URL url) {
        return String.format(this.getLoggingLocale(), this.parserFailure$str(), url);
    }

    protected String notFound$str() {
        return "WFLYCLJG0008: Failed to locate %s";
    }

    @Override
    public final String notFound(String resource) {
        return String.format(this.getLoggingLocale(), this.notFound$str(), resource);
    }

    protected String transportNotDefined$str() {
        return "WFLYCLJG0010: Transport for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.";
    }

    @Override
    public final OperationFailedException transportNotDefined(String stackName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.transportNotDefined$str(), stackName));
        JGroupsLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String unknownMetric$str() {
        return "WFLYCLJG0015: Unknown metric %s";
    }

    @Override
    public final String unknownMetric(String metricName) {
        return String.format(this.getLoggingLocale(), this.unknownMetric$str(), metricName);
    }

    protected String unableToLoadProtocolClass$str() {
        return "WFLYCLJG0016: Unable to load protocol class %s";
    }

    @Override
    public final OperationFailedException unableToLoadProtocolClass(String protocolName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToLoadProtocolClass$str(), protocolName));
        JGroupsLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyEntryNotFound$str() {
        return "WFLYCLJG0022: %s entry not found in configured key store";
    }

    @Override
    public final IllegalArgumentException keyEntryNotFound(String alias) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.keyEntryNotFound$str(), alias));
        JGroupsLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedKeyStoreEntryType$str() {
        return "WFLYCLJG0023: %s key store entry is not of the expected type: %s";
    }

    @Override
    public final IllegalArgumentException unexpectedKeyStoreEntryType(String alias, String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unexpectedKeyStoreEntryType$str(), alias, type));
        JGroupsLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedCredentialSource$str() {
        return "WFLYCLJG0025: Configured credential source does not reference a clear-text password credential";
    }

    @Override
    public final IllegalArgumentException unexpectedCredentialSource() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unexpectedCredentialSource$str(), new Object[0]));
        JGroupsLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToResolveSocketBinding$str() {
        return "WFLYCLJG0028: Could not resolve destination address for outbound socket binding named '%s'";
    }

    @Override
    public final IllegalArgumentException failedToResolveSocketBinding(UnknownHostException cause, OutboundSocketBinding binding) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failedToResolveSocketBinding$str(), binding), cause);
        JGroupsLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void legacyProtocol(String legacyProtocol, String targetProtocol) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.legacyProtocol$str(), (Object)legacyProtocol, (Object)targetProtocol);
    }

    protected String legacyProtocol$str() {
        return "WFLYCLJG0030: Protocol %s is obsolete and will be auto-updated to %s";
    }

    @Override
    public final void unrecognizedProtocolProperty(String protocol, String property) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unrecognizedProtocolProperty$str(), (Object)protocol, (Object)property);
    }

    protected String unrecognizedProtocolProperty$str() {
        return "WFLYCLJG0031: Ignoring unrecognized %s property: %s";
    }
}

