/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRegistryImpl;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;

@ConcurrentGauge
@Interceptor
@Priority(value=1010)
public class ConcurrentGaugeInterceptor {
    private final MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.APPLICATION);

    @Inject
    ConcurrentGaugeInterceptor() {
    }

    @AroundConstruct
    Object countedConstructor(InvocationContext context) throws Exception {
        return this.concurrentCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object countedMethod(InvocationContext context) throws Exception {
        return this.concurrentCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object countedTimeout(InvocationContext context) throws Exception {
        return this.concurrentCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object concurrentCallable(InvocationContext context, E element) throws Exception {
        Set<MetricID> ids = ((MetricsRegistryImpl)this.registry).getMemberToMetricMappings().getConcurrentGauges(new CDIMemberInfoAdapter<AnnotatedElement>().convert(element));
        if (ids == null || ids.isEmpty()) {
            throw SmallRyeMetricsMessages.msg.noMetricMappedForMember(element);
        }
        List metrics = ids.stream().map(metricID -> {
            org.eclipse.microprofile.metrics.ConcurrentGauge metric = (org.eclipse.microprofile.metrics.ConcurrentGauge)this.registry.getConcurrentGauges().get(metricID);
            if (metric == null) {
                throw SmallRyeMetricsMessages.msg.noMetricFoundInRegistry(MetricType.CONCURRENT_GAUGE, (MetricID)metricID);
            }
            return metric;
        }).collect(Collectors.toList());
        for (org.eclipse.microprofile.metrics.ConcurrentGauge metric : metrics) {
            metric.inc();
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            for (org.eclipse.microprofile.metrics.ConcurrentGauge metric : metrics) {
                metric.dec();
            }
        }
    }
}

