/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import io.opentelemetry.sdk.trace.SdkSpanBuilder;
import io.opentelemetry.sdk.trace.TracerSharedState;

final class SdkTracer
implements Tracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private final TracerSharedState sharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;

    SdkTracer(TracerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.sharedState = sharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.instrumentationLibraryInfo = InstrumentationScopeUtil.toInstrumentationLibraryInfo((InstrumentationScopeInfo)instrumentationScopeInfo);
    }

    public SpanBuilder spanBuilder(String spanName) {
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            Tracer tracer = TracerProvider.noop().get(this.instrumentationScopeInfo.getName());
            return tracer.spanBuilder(spanName);
        }
        return new SdkSpanBuilder(spanName, this.instrumentationLibraryInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }
}

