/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.common.annotation.impl.SearchProcessingWithContextException;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPath;
import org.hibernate.search.mapper.pojo.reporting.impl.PojoEventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public class PojoImplicitReindexingResolverPropertyNode<T, P>
extends PojoImplicitReindexingResolverNode<T> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ValueReadHandle<P> handle;
    private final PojoImplicitReindexingResolverNode<? super P> nested;
    private final PojoModelPath modelPath;

    public PojoImplicitReindexingResolverPropertyNode(ValueReadHandle<P> handle, PojoImplicitReindexingResolverNode<? super P> nested, PojoModelPath modelPath) {
        this.handle = handle;
        this.nested = nested;
        this.modelPath = modelPath;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(PojoImplicitReindexingResolverNode::close, this.nested);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"process property");
        builder.attribute("handle", this.handle);
        builder.attribute("nested", this.nested);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, T dirty, PojoImplicitReindexingResolverRootContext context) {
        try {
            Object propertyValue;
            try {
                propertyValue = this.handle.get(dirty);
            }
            catch (RuntimeException e) {
                context.propagateOrIgnorePropertyAccessException(e);
                return;
            }
            if (propertyValue != null) {
                this.nested.resolveEntitiesToReindex(collector, propertyValue, context);
            }
        }
        catch (SearchProcessingWithContextException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw log.searchProcessingFailure(e, e.getMessage(), PojoEventContexts.fromPath(this.modelPath));
        }
    }
}

