/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.metrics.MicrometerCollector;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

public class MicrometerCollectorService
implements Service<MicrometerCollector> {
    private final Supplier<ModelControllerClientFactory> modelControllerClientFactory;
    private final Supplier<Executor> managementExecutor;
    private final Supplier<ProcessStateNotifier> processStateNotifier;
    private final Supplier<WildFlyRegistry> registrySupplier;
    private Consumer<MicrometerCollector> metricCollectorConsumer;
    private MicrometerCollector micrometerCollector;
    private LocalModelControllerClient modelControllerClient;

    public static void install(OperationContext context) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicrometerSubsystemDefinition.MICROMETER_COLLECTOR);
        Supplier modelControllerClientFactory = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class));
        Supplier managementExecutor = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.executor", Executor.class));
        Supplier processStateNotifier = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.process-state-notifier", ProcessStateNotifier.class));
        Supplier registrySupplier = serviceBuilder.requires(MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName());
        Consumer metricCollectorConsumer = serviceBuilder.provides(new ServiceName[]{MicrometerSubsystemDefinition.MICROMETER_COLLECTOR});
        MicrometerCollectorService service = new MicrometerCollectorService(modelControllerClientFactory, managementExecutor, processStateNotifier, registrySupplier, metricCollectorConsumer);
        serviceBuilder.setInstance((org.jboss.msc.Service)service).install();
    }

    MicrometerCollectorService(Supplier<ModelControllerClientFactory> modelControllerClientFactory, Supplier<Executor> managementExecutor, Supplier<ProcessStateNotifier> processStateNotifier, Supplier<WildFlyRegistry> registrySupplier, Consumer<MicrometerCollector> metricCollectorConsumer) {
        this.modelControllerClientFactory = modelControllerClientFactory;
        this.managementExecutor = managementExecutor;
        this.processStateNotifier = processStateNotifier;
        this.registrySupplier = registrySupplier;
        this.metricCollectorConsumer = metricCollectorConsumer;
    }

    public void start(StartContext context) {
        this.modelControllerClient = this.modelControllerClientFactory.get().createClient(this.managementExecutor.get());
        this.micrometerCollector = new MicrometerCollector(this.modelControllerClient, this.processStateNotifier.get(), this.registrySupplier.get());
        this.metricCollectorConsumer.accept(this.micrometerCollector);
    }

    public void stop(StopContext context) {
        this.metricCollectorConsumer.accept(null);
        this.micrometerCollector = null;
        this.modelControllerClient.close();
    }

    public MicrometerCollector getValue() throws IllegalStateException, IllegalArgumentException {
        return this.micrometerCollector;
    }
}

