/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import io.undertow.util.HttpString;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.metrics.MetricsContextService;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

class MicrometerContextService
implements Service {
    public static final String CONTEXT = "/metrics";
    private final Consumer<MicrometerContextService> consumer;
    private final Supplier<MetricsContextService> metricsContextService;
    private final Supplier<Boolean> securityEnabledSupplier;
    private final Supplier<WildFlyRegistry> registrySupplier;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    static MicrometerContextService install(OperationContext context, boolean securityEnabled) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicrometerSubsystemDefinition.MICROMETER_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName());
        Supplier metricsContextService = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.extension.metrics.http-context", MetricsContextService.class));
        Supplier registries = serviceBuilder.requires(context.getCapabilityServiceName(MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getName(), WildFlyRegistry.class));
        Consumer metricsContext = serviceBuilder.provides(new ServiceName[]{MicrometerSubsystemDefinition.MICROMETER_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName()});
        Supplier securityEnabledSupplier = context.getCapabilityServiceSupport().hasCapability("org.wildfly.extension.micrometer.http-context.security-enabled") ? serviceBuilder.requires(ServiceName.parse((String)"org.wildfly.extension.micrometer.http-context.security-enabled")) : () -> securityEnabled;
        MicrometerContextService service = new MicrometerContextService(metricsContext, metricsContextService, securityEnabledSupplier, registries);
        serviceBuilder.setInstance((Service)service).install();
        return service;
    }

    private MicrometerContextService(Consumer<MicrometerContextService> consumer, Supplier<MetricsContextService> metricsContextService, Supplier<Boolean> securityEnabledSupplier, Supplier<WildFlyRegistry> registrySupplier) {
        this.consumer = consumer;
        this.metricsContextService = metricsContextService;
        this.securityEnabledSupplier = securityEnabledSupplier;
        this.registrySupplier = registrySupplier;
    }

    public void start(StartContext context) {
        this.metricsContextService.get().setOverrideableMetricHandler(exchange -> {
            this.lock.readLock().lock();
            try {
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"X-WildFly-Metrics"), "micrometer");
                exchange.getResponseSender().send(this.registrySupplier.get().scrape());
            }
            finally {
                this.lock.readLock().unlock();
            }
        });
        this.consumer.accept(this);
    }

    public void stop(StopContext context) {
        this.metricsContextService.get().setOverrideableMetricHandler(null);
        this.registrySupplier.get().clear();
        this.consumer.accept(null);
    }
}

