/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;

public class MicrometerDependencyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        this.addDependencies(phaseContext.getDeploymentUnit());
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    private void addDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (String module : MicrometerSubsystemDefinition.MODULES) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, module, false, false, true, false));
        }
        for (String module : MicrometerSubsystemDefinition.EXPORTED_MODULES) {
            ModuleDependency modDep = new ModuleDependency(moduleLoader, module, false, true, true, false);
            moduleSpecification.addSystemDependency(modDep);
        }
    }
}

