/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.ServerService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentCompleteServiceProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.micrometer.MicrometerExtensionLogger;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.api.MicrometerCdiExtension;
import org.wildfly.extension.micrometer.metrics.MicrometerCollector;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MicrometerDeploymentService
implements Service {
    private final Resource rootResource;
    private final ManagementResourceRegistration managementResourceRegistration;
    private final PathAddress deploymentAddress;
    private final DeploymentUnit deploymentUnit;
    private final Supplier<MicrometerCollector> metricCollector;
    private final Supplier<Executor> managementExecutor;
    private final Supplier<WildFlyRegistry> registrySupplier;
    private final boolean exposeAnySubsystem;
    private final List<String> exposedSubsystems;

    public static void install(ServiceTarget serviceTarget, DeploymentPhaseContext deploymentPhaseContext, Resource rootResource, ManagementResourceRegistration managementResourceRegistration, boolean exposeAnySubsystem, List<String> exposedSubsystems) throws DeploymentUnitProcessingException {
        MicrometerExtensionLogger.MICROMETER_LOGGER.processingDeployment();
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        try {
            WeldCapability weldCapability = (WeldCapability)((CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT)).getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            if (!weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                MicrometerExtensionLogger.MICROMETER_LOGGER.noCdiDeployment();
                return;
            }
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw MicrometerExtensionLogger.MICROMETER_LOGGER.deploymentRequiresCapability(deploymentPhaseContext.getDeploymentUnit().getName(), "org.wildfly.weld");
        }
        PathAddress deploymentAddress = MicrometerDeploymentService.createDeploymentAddressPrefix(deploymentUnit);
        ServiceBuilder sb = serviceTarget.addService(deploymentUnit.getServiceName().append(new String[]{".micrometer-metrics"}));
        Supplier metricCollectorSupplier = sb.requires(MicrometerSubsystemDefinition.MICROMETER_COLLECTOR);
        Supplier managementExecutorSupplier = sb.requires(ServerService.EXECUTOR_CAPABILITY.getCapabilityServiceName());
        Supplier registriesSupplier = sb.requires(MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getCapabilityServiceName());
        sb.requires(DeploymentCompleteServiceProcessor.serviceName((ServiceName)deploymentUnit.getServiceName()));
        sb.setInstance((Service)new MicrometerDeploymentService(rootResource, managementResourceRegistration, deploymentAddress, deploymentUnit, metricCollectorSupplier, managementExecutorSupplier, registriesSupplier, exposeAnySubsystem, exposedSubsystems)).install();
    }

    private MicrometerDeploymentService(Resource rootResource, ManagementResourceRegistration managementResourceRegistration, PathAddress deploymentAddress, DeploymentUnit deploymentUnit, Supplier<MicrometerCollector> metricCollectorSupplier, Supplier<Executor> managementExecutorSupplier, Supplier<WildFlyRegistry> registrySupplier, boolean exposeAnySubsystem, List<String> exposedSubsystems) {
        this.rootResource = rootResource;
        this.managementResourceRegistration = managementResourceRegistration;
        this.deploymentAddress = deploymentAddress;
        this.deploymentUnit = deploymentUnit;
        this.metricCollector = metricCollectorSupplier;
        this.managementExecutor = managementExecutorSupplier;
        this.registrySupplier = registrySupplier;
        this.exposeAnySubsystem = exposeAnySubsystem;
        this.exposedSubsystems = exposedSubsystems;
    }

    private static PathAddress createDeploymentAddressPrefix(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            return PathAddress.pathAddress((String)"deployment", (String)((String)deploymentUnit.getAttachment(Attachments.MANAGEMENT_NAME)));
        }
        return MicrometerDeploymentService.createDeploymentAddressPrefix(deploymentUnit.getParent()).append("subdeployment", deploymentUnit.getName());
    }

    public void start(StartContext context) {
        this.metricCollector.get().collectResourceMetrics(this.rootResource, (ImmutableManagementResourceRegistration)this.managementResourceRegistration, address -> this.deploymentAddress.append(address), this.exposeAnySubsystem, this.exposedSubsystems);
        this.setupMicrometerCdiBeans();
    }

    public void stop(StopContext context) {
    }

    private void setupMicrometerCdiBeans() {
        ClassLoader initialCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            ModuleClassLoader moduleCL = ((Module)this.deploymentUnit.getAttachment(Attachments.MODULE)).getClassLoader();
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)moduleCL);
            MicrometerCdiExtension.registerApplicationRegistry((ClassLoader)moduleCL, (MeterRegistry)((MeterRegistry)this.registrySupplier.get()));
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)initialCl);
        }
    }
}

