/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYMMTREXT", length=4)
public interface MicrometerExtensionLogger
extends BasicLogger {
    public static final MicrometerExtensionLogger MICROMETER_LOGGER = (MicrometerExtensionLogger)Logger.getMessageLogger(MicrometerExtensionLogger.class, (String)MicrometerExtensionLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating Micrometer Subsystem")
    public void activatingSubsystem();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Micrometer Subsystem is processing deployment")
    public void processingDeployment();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="The deployment does not have Jakarta Contexts and Dependency Injection enabled. Skipping Micrometer integration.")
    public void noCdiDeployment();

    @Message(id=4, value="Deployment %s requires use of the '%s' capability but it is not currently registered")
    public DeploymentUnitProcessingException deploymentRequiresCapability(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Unable to read attribute %s on %s: %s.")
    public void unableToReadAttribute(String var1, PathAddress var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Unable to convert attribute %s on %s to Double value.")
    public void unableToConvertAttribute(String var1, PathAddress var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Malformed name.")
    public void malformedName(@Cause Exception var1);

    @Message(id=8, value="Failed to initialize metrics from JMX MBeans")
    public IllegalArgumentException failedInitializeJMXRegistrar(@Cause IOException var1);

    @Message(id=9, value="An unsupported metric type was found: %s")
    public IllegalArgumentException unsupportedMetricType(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10, value="Not activating Micrometer Subsystem")
    public void notActivatingSubsystem();
}

