/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import java.util.List;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitsInApplication;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.processor.HibernateSearchDeploymentMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.JPADeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class HibernateSearchProcessor
implements DeploymentUnitProcessor {
    private static final DotName ANNOTATION_LEGACY_INDEXED_NAME = DotName.createSimple((String)"org.hibernate.search.annotations.Indexed");
    private static final DotName ANNOTATION_INDEXED_NAME = DotName.createSimple((String)"org.hibernate.search.mapper.pojo.mapping.definition.annotation.Indexed");
    private static final String MODULE_MAPPER_ORM_LEGACY = "org.hibernate.search.orm";
    private static final ModuleIdentifier MODULE_MAPPER_ORM_DEFAULT = ModuleIdentifier.fromString((String)"org.hibernate.search.mapper.orm");
    private static final ModuleIdentifier MODULE_MAPPER_ORM_COORDINATION_OUTBOXPOLLING = ModuleIdentifier.fromString((String)"org.hibernate.search.mapper.orm.coordination.outboxpolling");
    private static final ModuleIdentifier MODULE_BACKEND_LUCENE = ModuleIdentifier.fromString((String)"org.hibernate.search.backend.lucene");
    private static final ModuleIdentifier MODULE_BACKEND_ELASTICSEARCH = ModuleIdentifier.fromString((String)"org.hibernate.search.backend.elasticsearch");
    private static final String NONE = "none";
    private static final String IGNORE = "auto";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (JPADeploymentMarker.isJPADeployment((DeploymentUnit)deploymentUnit)) {
            this.addSearchDependency(moduleSpecification, moduleLoader, deploymentUnit);
        }
    }

    private void addSearchDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        List<String> coordinationStrategies;
        String searchMapperModuleName = null;
        PersistenceUnitsInApplication persistenceUnitsInApplication = (PersistenceUnitsInApplication)DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)deploymentUnit).getAttachment(PersistenceUnitsInApplication.PERSISTENCE_UNITS_IN_APPLICATION);
        for (PersistenceUnitMetadataHolder holder : persistenceUnitsInApplication.getPersistenceUnitHolders()) {
            for (PersistenceUnitMetadata pu : holder.getPersistenceUnits()) {
                String providerModule = pu.getProperties().getProperty("wildfly.jpa.hibernate.search.module");
                if (providerModule == null) continue;
                if (searchMapperModuleName == null) {
                    searchMapperModuleName = providerModule;
                    continue;
                }
                if (providerModule.equals(searchMapperModuleName)) continue;
                throw JpaLogger.ROOT_LOGGER.differentSearchModuleDependencies(deploymentUnit.getName(), searchMapperModuleName, providerModule);
            }
        }
        if (NONE.equals(searchMapperModuleName)) {
            JpaLogger.ROOT_LOGGER.debugf("Not adding Hibernate Search dependency to deployment %s", deploymentUnit.getName());
            return;
        }
        if (searchMapperModuleName != null && !IGNORE.equals(searchMapperModuleName)) {
            ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromString(searchMapperModuleName);
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, true, true, false));
            JpaLogger.ROOT_LOGGER.debugf("added %s dependency to %s", moduleIdentifier, deploymentUnit.getName());
        } else {
            CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
            List annotations = index.getAnnotations(ANNOTATION_INDEXED_NAME);
            if (annotations != null && !annotations.isEmpty()) {
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, MODULE_MAPPER_ORM_DEFAULT, false, true, true, false));
                JpaLogger.ROOT_LOGGER.debugf("deployment %s contains %s annotation, added %s dependency", deploymentUnit.getName(), ANNOTATION_INDEXED_NAME, MODULE_MAPPER_ORM_DEFAULT);
            } else {
                List legacyAnnotations = index.getAnnotations(ANNOTATION_LEGACY_INDEXED_NAME);
                if (legacyAnnotations != null && !legacyAnnotations.isEmpty()) {
                    moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, MODULE_MAPPER_ORM_LEGACY, false, true, true, false));
                    JpaLogger.ROOT_LOGGER.debugf("deployment %s contains %s annotation, added %s dependency", deploymentUnit.getName(), ANNOTATION_LEGACY_INDEXED_NAME, MODULE_MAPPER_ORM_LEGACY);
                }
            }
        }
        List<String> backendTypes = HibernateSearchDeploymentMarker.getBackendTypes(deploymentUnit);
        if (backendTypes != null) {
            if (backendTypes.contains("lucene")) {
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, MODULE_BACKEND_LUCENE, false, true, true, false));
            }
            if (backendTypes.contains("elasticsearch")) {
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, MODULE_BACKEND_ELASTICSEARCH, false, true, true, false));
            }
        }
        if ((coordinationStrategies = HibernateSearchDeploymentMarker.getCoordinationStrategies(deploymentUnit)) != null && coordinationStrategies.contains("outbox-polling")) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, MODULE_MAPPER_ORM_COORDINATION_OUTBOXPOLLING, false, true, true, false));
        }
    }
}

