/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.EnumSet;
import org.jboss.as.clustering.controller.Schema;
import org.jboss.as.clustering.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.clustering.web.DistributableWebModel;
import org.wildfly.extension.clustering.web.DistributableWebResourceDefinition;
import org.wildfly.extension.clustering.web.DistributableWebResourceDescriptionResolver;
import org.wildfly.extension.clustering.web.DistributableWebSchema;
import org.wildfly.extension.clustering.web.DistributableWebXMLParser;

public class DistributableWebExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "distributable-web";
    static final SubsystemResourceDescriptionResolver SUBSYSTEM_RESOLVER = new DistributableWebResourceDescriptionResolver();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, DistributableWebModel.CURRENT.getVersion());
        new DistributableWebResourceDefinition().register(registration);
        registration.registerXMLElementWriter((XMLElementWriter)new DistributableWebXMLParser(DistributableWebSchema.CURRENT));
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Schema schema : EnumSet.allOf(DistributableWebSchema.class)) {
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespaceUri(), (XMLElementReader)new DistributableWebXMLParser((Schema<DistributableWebSchema>)schema));
        }
    }
}

