/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin.impl;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.admin.Config;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.DescribeClusterOptions;
import io.vertx.kafka.admin.DescribeConsumerGroupsOptions;
import io.vertx.kafka.admin.DescribeTopicsOptions;
import io.vertx.kafka.admin.KafkaAdminClient;
import io.vertx.kafka.admin.ListConsumerGroupOffsetsOptions;
import io.vertx.kafka.admin.ListOffsetsResultInfo;
import io.vertx.kafka.admin.MemberDescription;
import io.vertx.kafka.admin.NewPartitions;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.OffsetSpec;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.client.common.ConfigResource;
import io.vertx.kafka.client.common.Node;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.common.impl.Helper;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;

public class KafkaAdminClientImpl
implements KafkaAdminClient {
    private Vertx vertx;
    private AdminClient adminClient;

    public KafkaAdminClientImpl(Vertx vertx, AdminClient adminClient) {
        this.vertx = vertx;
        this.adminClient = adminClient;
    }

    @Override
    public void describeTopics(List<String> topicNames, Handler<AsyncResult<Map<String, TopicDescription>>> completionHandler) {
        this.describeTopics(topicNames).onComplete(completionHandler);
    }

    @Override
    public Future<Map<String, TopicDescription>> describeTopics(List<String> topicNames) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeTopicsResult describeTopicsResult = this.adminClient.describeTopics(topicNames);
        describeTopicsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeTopics$0((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void describeTopics(List<String> topicNames, DescribeTopicsOptions options, Handler<AsyncResult<Map<String, TopicDescription>>> completionHandler) {
        this.describeTopics(topicNames, options).onComplete(completionHandler);
    }

    @Override
    public Future<Map<String, TopicDescription>> describeTopics(List<String> topicNames, DescribeTopicsOptions options) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeTopicsResult describeTopicsResult = this.adminClient.describeTopics(topicNames, Helper.to(options));
        describeTopicsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeTopics$1((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    @GenIgnore
    public void describeLogDirs(List<Integer> brokers, Handler<AsyncResult<Map<Integer, Map<String, LogDirDescription>>>> completionHandler) {
        this.describeLogDirs(brokers).onComplete(completionHandler);
    }

    @Override
    @GenIgnore
    public Future<Map<Integer, Map<String, LogDirDescription>>> describeLogDirs(List<Integer> brokers) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeLogDirsResult describeLogDirsResult = this.adminClient.describeLogDirs(brokers);
        describeLogDirsResult.allDescriptions().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeLogDirs$2((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void listTopics(Handler<AsyncResult<Set<String>>> completionHandler) {
        this.listTopics().onComplete(completionHandler);
    }

    @Override
    public Future<Set<String>> listTopics() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        ListTopicsResult listTopicsResult = this.adminClient.listTopics();
        listTopicsResult.names().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$listTopics$3((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void createTopics(List<NewTopic> topics, Handler<AsyncResult<Void>> completionHandler) {
        this.createTopics(topics).onComplete(completionHandler);
    }

    @Override
    public Future<Void> createTopics(List<NewTopic> topics) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        CreateTopicsResult createTopicsResult = this.adminClient.createTopics(Helper.toNewTopicList(topics));
        createTopicsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$createTopics$4((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void deleteTopics(List<String> topicNames, Handler<AsyncResult<Void>> completionHandler) {
        this.deleteTopics(topicNames).onComplete(completionHandler);
    }

    @Override
    public Future<Void> deleteTopics(List<String> topicNames) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DeleteTopicsResult deleteTopicsResult = this.adminClient.deleteTopics(topicNames);
        deleteTopicsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$deleteTopics$5((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    @GenIgnore
    public void deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete, Handler<AsyncResult<Map<TopicPartition, DeletedRecords>>> completionHandler) {
        this.deleteRecords(recordsToDelete).onComplete(completionHandler);
    }

    @Override
    @GenIgnore
    public Future<Map<TopicPartition, DeletedRecords>> deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        HashMap<org.apache.kafka.common.TopicPartition, RecordsToDelete> recordsToDeleteKafka = new HashMap<org.apache.kafka.common.TopicPartition, RecordsToDelete>();
        for (Map.Entry<TopicPartition, RecordsToDelete> entry : recordsToDelete.entrySet()) {
            recordsToDeleteKafka.put(Helper.to(entry.getKey()), entry.getValue());
        }
        DeleteRecordsResult deleteRecordsResult = this.adminClient.deleteRecords(recordsToDeleteKafka);
        Map deletedRecordsInfo = deleteRecordsResult.lowWatermarks();
        HashMap deletedRecordsInfoMap = new HashMap();
        ArrayList<Future> deletedRecords = new ArrayList<Future>();
        ArrayList topicPartitions = new ArrayList();
        for (Map.Entry entry : deletedRecordsInfo.entrySet()) {
            PromiseInternal promise1 = ctx.promise();
            topicPartitions.add(entry.getKey());
            deletedRecords.add(promise1.future());
            ((KafkaFuture)entry.getValue()).whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$deleteRecords$6((Promise)promise1, arg_0, arg_1));
        }
        CompositeFuture.join(deletedRecords).onComplete(arg_0 -> KafkaAdminClientImpl.lambda$deleteRecords$7((Promise)promise, deletedRecordsInfoMap, topicPartitions, arg_0));
        return promise.future();
    }

    @Override
    public void createPartitions(Map<String, NewPartitions> partitions, Handler<AsyncResult<Void>> completionHandler) {
        this.createPartitions(partitions).onComplete(completionHandler);
    }

    @Override
    public Future<Void> createPartitions(Map<String, NewPartitions> partitions) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        CreatePartitionsResult createPartitionsResult = this.adminClient.createPartitions(Helper.toPartitions(partitions));
        createPartitionsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$createPartitions$8((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void describeConfigs(List<ConfigResource> configResources, Handler<AsyncResult<Map<ConfigResource, Config>>> completionHandler) {
        this.describeConfigs(configResources).onComplete(completionHandler);
    }

    @Override
    public Future<Map<ConfigResource, Config>> describeConfigs(List<ConfigResource> configResources) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeConfigsResult describeConfigsResult = this.adminClient.describeConfigs(Helper.toConfigResourceList(configResources));
        describeConfigsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeConfigs$9((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void alterConfigs(Map<ConfigResource, Config> configs, Handler<AsyncResult<Void>> completionHandler) {
        this.alterConfigs(configs).onComplete(completionHandler);
    }

    @Override
    public Future<Void> alterConfigs(Map<ConfigResource, Config> configs) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        AlterConfigsResult alterConfigsResult = this.adminClient.incrementalAlterConfigs(Helper.toConfigMaps(configs));
        alterConfigsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$alterConfigs$10((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void listConsumerGroups(Handler<AsyncResult<List<ConsumerGroupListing>>> completionHandler) {
        this.listConsumerGroups().onComplete(completionHandler);
    }

    @Override
    public Future<List<ConsumerGroupListing>> listConsumerGroups() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        ListConsumerGroupsResult listConsumerGroupsResult = this.adminClient.listConsumerGroups();
        listConsumerGroupsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$listConsumerGroups$11((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void describeConsumerGroups(List<String> groupIds, Handler<AsyncResult<Map<String, ConsumerGroupDescription>>> completionHandler) {
        this.describeConsumerGroups(groupIds).onComplete(completionHandler);
    }

    @Override
    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> groupIds) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeConsumerGroupsResult describeConsumerGroupsResult = this.adminClient.describeConsumerGroups(groupIds);
        describeConsumerGroupsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeConsumerGroups$12((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void describeConsumerGroups(List<String> groupIds, DescribeConsumerGroupsOptions options, Handler<AsyncResult<Map<String, ConsumerGroupDescription>>> completionHandler) {
        this.describeConsumerGroups(groupIds, options).onComplete(completionHandler);
    }

    @Override
    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> groupIds, DescribeConsumerGroupsOptions options) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeConsumerGroupsResult describeConsumerGroupsResult = this.adminClient.describeConsumerGroups(groupIds, Helper.to(options));
        describeConsumerGroupsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeConsumerGroups$13((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void listConsumerGroupOffsets(String groupId, ListConsumerGroupOffsetsOptions options, Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> completionHandler) {
        this.listConsumerGroupOffsets(groupId, options).onComplete(completionHandler);
    }

    @Override
    public Future<Map<TopicPartition, OffsetAndMetadata>> listConsumerGroupOffsets(String groupId, ListConsumerGroupOffsetsOptions options) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult = this.adminClient.listConsumerGroupOffsets(groupId, Helper.to(options));
        listConsumerGroupOffsetsResult.partitionsToOffsetAndMetadata().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$listConsumerGroupOffsets$14((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void deleteConsumerGroups(List<String> groupIds, Handler<AsyncResult<Void>> completionHandler) {
        this.deleteConsumerGroups(groupIds).onComplete(completionHandler);
    }

    @Override
    public Future<Void> deleteConsumerGroups(List<String> groupIds) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DeleteConsumerGroupsResult deleteConsumerGroupsResult = this.adminClient.deleteConsumerGroups(groupIds);
        deleteConsumerGroupsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$deleteConsumerGroups$15((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, Handler<AsyncResult<Void>> completionHandler) {
        this.alterConsumerGroupOffsets(groupId, offsets).onComplete(completionHandler);
    }

    @Override
    public Future<Void> alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult = this.adminClient.alterConsumerGroupOffsets(groupId, Helper.to(offsets));
        alterConsumerGroupOffsetsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$alterConsumerGroupOffsets$16((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, Handler<AsyncResult<Void>> completionHandler) {
        this.deleteConsumerGroupOffsets(groupId, partitions).onComplete(completionHandler);
    }

    @Override
    public Future<Void> deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsetsResult = this.adminClient.deleteConsumerGroupOffsets(groupId, Helper.toTopicPartitionSet(partitions));
        deleteConsumerGroupOffsetsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$deleteConsumerGroupOffsets$17((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void describeCluster(Handler<AsyncResult<ClusterDescription>> completionHandler) {
        this.describeCluster().onComplete(completionHandler);
    }

    @Override
    public Future<ClusterDescription> describeCluster() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeClusterResult describeClusterResult = this.adminClient.describeCluster();
        KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{describeClusterResult.clusterId(), describeClusterResult.controller(), describeClusterResult.nodes()}).whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeCluster$19(describeClusterResult, (Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void describeCluster(DescribeClusterOptions options, Handler<AsyncResult<ClusterDescription>> completionHandler) {
        this.describeCluster(options).onComplete(completionHandler);
    }

    @Override
    public Future<ClusterDescription> describeCluster(DescribeClusterOptions options) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeClusterResult describeClusterResult = this.adminClient.describeCluster(Helper.to(options));
        KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{describeClusterResult.clusterId(), describeClusterResult.controller(), describeClusterResult.nodes()}).whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeCluster$21(describeClusterResult, (Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, Handler<AsyncResult<Map<TopicPartition, ListOffsetsResultInfo>>> completionHandler) {
        this.listOffsets(topicPartitionOffsets).onComplete(completionHandler);
    }

    @Override
    public Future<Map<TopicPartition, ListOffsetsResultInfo>> listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        ListOffsetsResult listOffsetsResult = this.adminClient.listOffsets(Helper.toTopicPartitionOffsets(topicPartitionOffsets));
        listOffsetsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$listOffsets$22((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void describeAcls(AclBindingFilter aclBindingFilter, Handler<AsyncResult<List<AclBinding>>> completionHandler) {
        this.describeAcls(aclBindingFilter).onComplete(completionHandler);
    }

    @Override
    public Future<List<AclBinding>> describeAcls(AclBindingFilter aclBindingFilter) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DescribeAclsResult describeAclsResult = this.adminClient.describeAcls(aclBindingFilter);
        describeAclsResult.values().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$describeAcls$24((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void createAcls(List<AclBinding> aclBindings, Handler<AsyncResult<List<AclBinding>>> completionHandler) {
        this.createAcls(aclBindings).onComplete(completionHandler);
    }

    @Override
    public Future<List<AclBinding>> createAcls(List<AclBinding> aclBindings) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        CreateAclsResult createAclsResult = this.adminClient.createAcls(aclBindings);
        createAclsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$createAcls$25((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public void deleteAcls(List<AclBindingFilter> aclBindingsFilters, Handler<AsyncResult<List<AclBinding>>> completionHandler) {
        this.deleteAcls(aclBindingsFilters).onComplete(completionHandler);
    }

    @Override
    public Future<List<AclBinding>> deleteAcls(List<AclBindingFilter> aclBindingsFilters) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        PromiseInternal promise = ctx.promise();
        DeleteAclsResult deleteAclsResult = this.adminClient.deleteAcls(aclBindingsFilters);
        deleteAclsResult.all().whenComplete((arg_0, arg_1) -> KafkaAdminClientImpl.lambda$deleteAcls$26((Promise)promise, arg_0, arg_1));
        return promise.future();
    }

    @Override
    public Future<Void> close() {
        return this.close(0L);
    }

    @Override
    public Future<Void> close(long timeout) {
        return this.vertx.executeBlocking(prom -> {
            if (timeout > 0L) {
                this.adminClient.close(Duration.ofMillis(timeout));
            } else {
                this.adminClient.close();
            }
            prom.complete();
        });
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.close().onComplete(handler);
    }

    @Override
    public void close(long timeout, Handler<AsyncResult<Void>> handler) {
        this.close(timeout).onComplete(handler);
    }

    private static /* synthetic */ void lambda$deleteAcls$26(Promise promise, Collection o, Throwable ex) {
        if (ex == null) {
            promise.complete((Object)((List)o));
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$createAcls$25(Promise promise, Void o, Throwable ex) {
        if (ex == null) {
            promise.complete();
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeAcls$24(Promise promise, Collection o, Throwable ex) {
        if (ex == null) {
            List list = o.stream().map(entry -> new AclBinding(entry.pattern(), entry.entry())).collect(Collectors.toList());
            promise.complete(list);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$listOffsets$22(Promise promise, Map o, Throwable ex) {
        if (ex == null) {
            HashMap<TopicPartition, ListOffsetsResultInfo> listOffsets = new HashMap<TopicPartition, ListOffsetsResultInfo>();
            for (Map.Entry oOffset : o.entrySet()) {
                listOffsets.put(Helper.from((org.apache.kafka.common.TopicPartition)oOffset.getKey()), Helper.from((ListOffsetsResult.ListOffsetsResultInfo)oOffset.getValue()));
            }
            promise.complete(listOffsets);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeCluster$21(DescribeClusterResult describeClusterResult, Promise promise, Void r, Throwable ex) {
        if (ex == null) {
            try {
                String clusterId = (String)describeClusterResult.clusterId().get();
                org.apache.kafka.common.Node rcontroller = (org.apache.kafka.common.Node)describeClusterResult.controller().get();
                Collection rnodes = (Collection)describeClusterResult.nodes().get();
                Node controller = Helper.from(rcontroller);
                ArrayList<Node> nodes = new ArrayList<Node>();
                rnodes.forEach(rnode -> nodes.add(Helper.from(rnode)));
                ClusterDescription clusterDescription = new ClusterDescription(clusterId, controller, nodes);
                promise.complete((Object)clusterDescription);
            }
            catch (InterruptedException | ExecutionException e) {
                promise.fail((Throwable)e);
            }
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeCluster$19(DescribeClusterResult describeClusterResult, Promise promise, Void r, Throwable ex) {
        if (ex == null) {
            try {
                String clusterId = (String)describeClusterResult.clusterId().get();
                org.apache.kafka.common.Node rcontroller = (org.apache.kafka.common.Node)describeClusterResult.controller().get();
                Collection rnodes = (Collection)describeClusterResult.nodes().get();
                Node controller = Helper.from(rcontroller);
                ArrayList<Node> nodes = new ArrayList<Node>();
                rnodes.forEach(rnode -> nodes.add(Helper.from(rnode)));
                ClusterDescription clusterDescription = new ClusterDescription(clusterId, controller, nodes);
                promise.complete((Object)clusterDescription);
            }
            catch (InterruptedException | ExecutionException e) {
                promise.fail((Throwable)e);
            }
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$deleteConsumerGroupOffsets$17(Promise promise, Void v, Throwable ex) {
        if (ex == null) {
            promise.complete();
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$alterConsumerGroupOffsets$16(Promise promise, Void v, Throwable ex) {
        if (ex == null) {
            promise.complete();
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$deleteConsumerGroups$15(Promise promise, Void v, Throwable ex) {
        if (ex == null) {
            promise.complete();
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$listConsumerGroupOffsets$14(Promise promise, Map cgo, Throwable ex) {
        if (ex == null) {
            HashMap<TopicPartition, OffsetAndMetadata> consumerGroupOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
            for (Map.Entry cgoOffset : cgo.entrySet()) {
                consumerGroupOffsets.put(Helper.from((org.apache.kafka.common.TopicPartition)cgoOffset.getKey()), Helper.from((org.apache.kafka.clients.consumer.OffsetAndMetadata)cgoOffset.getValue()));
            }
            promise.complete(consumerGroupOffsets);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeConsumerGroups$13(Promise promise, Map cg, Throwable ex) {
        if (ex == null) {
            HashMap consumerGroups = new HashMap();
            for (Map.Entry cgDescriptionEntry : cg.entrySet()) {
                ArrayList<MemberDescription> members = new ArrayList<MemberDescription>();
                for (org.apache.kafka.clients.admin.MemberDescription memberDescription : ((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).members()) {
                    MemberDescription m = new MemberDescription();
                    m.setConsumerId(memberDescription.consumerId()).setClientId(memberDescription.clientId()).setAssignment(Helper.from(memberDescription.assignment())).setHost(memberDescription.host());
                    members.add(m);
                }
                ConsumerGroupDescription consumerGroupDescription = new ConsumerGroupDescription();
                consumerGroupDescription.setGroupId(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).groupId()).setCoordinator(Helper.from(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).coordinator())).setMembers(members).setPartitionAssignor(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).partitionAssignor()).setSimpleConsumerGroup(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).isSimpleConsumerGroup()).setState(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).state());
                consumerGroups.put(cgDescriptionEntry.getKey(), consumerGroupDescription);
            }
            promise.complete(consumerGroups);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeConsumerGroups$12(Promise promise, Map cg, Throwable ex) {
        if (ex == null) {
            HashMap consumerGroups = new HashMap();
            for (Map.Entry cgDescriptionEntry : cg.entrySet()) {
                ArrayList<MemberDescription> members = new ArrayList<MemberDescription>();
                for (org.apache.kafka.clients.admin.MemberDescription memberDescription : ((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).members()) {
                    MemberDescription m = new MemberDescription();
                    m.setConsumerId(memberDescription.consumerId()).setClientId(memberDescription.clientId()).setAssignment(Helper.from(memberDescription.assignment())).setHost(memberDescription.host());
                    members.add(m);
                }
                ConsumerGroupDescription consumerGroupDescription = new ConsumerGroupDescription();
                consumerGroupDescription.setGroupId(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).groupId()).setCoordinator(Helper.from(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).coordinator())).setMembers(members).setPartitionAssignor(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).partitionAssignor()).setSimpleConsumerGroup(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).isSimpleConsumerGroup()).setState(((org.apache.kafka.clients.admin.ConsumerGroupDescription)cgDescriptionEntry.getValue()).state());
                consumerGroups.put(cgDescriptionEntry.getKey(), consumerGroupDescription);
            }
            promise.complete(consumerGroups);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$listConsumerGroups$11(Promise promise, Collection groupIds, Throwable ex) {
        if (ex == null) {
            promise.complete(Helper.fromConsumerGroupListings(groupIds));
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$alterConfigs$10(Promise promise, Void v, Throwable ex) {
        if (ex == null) {
            promise.complete();
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeConfigs$9(Promise promise, Map m, Throwable ex) {
        if (ex == null) {
            HashMap<ConfigResource, Config> configs = new HashMap<ConfigResource, Config>();
            for (Map.Entry configEntry : m.entrySet()) {
                ConfigResource configResource = Helper.from((org.apache.kafka.common.config.ConfigResource)configEntry.getKey());
                Config config = Helper.from((org.apache.kafka.clients.admin.Config)configEntry.getValue());
                configs.put(configResource, config);
            }
            promise.complete(configs);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$createPartitions$8(Promise promise, Void v, Throwable ex) {
        if (ex == null) {
            promise.handle((AsyncResult)Future.succeededFuture());
        } else {
            promise.handle((AsyncResult)Future.failedFuture((Throwable)ex));
        }
    }

    private static /* synthetic */ void lambda$deleteRecords$7(Promise promise, Map deletedRecordsInfoMap, List topicPartitions, AsyncResult drs) {
        if (drs.failed()) {
            promise.fail("Error message drs: " + drs);
            return;
        }
        List recordList = ((CompositeFuture)drs.result()).list();
        for (int i = 0; i < recordList.size(); ++i) {
            deletedRecordsInfoMap.put(Helper.from((org.apache.kafka.common.TopicPartition)topicPartitions.get(i)), recordList.get(i));
        }
        promise.complete((Object)deletedRecordsInfoMap);
    }

    private static /* synthetic */ void lambda$deleteRecords$6(Promise promise1, DeletedRecords dr, Throwable ex) {
        if (ex == null) {
            promise1.complete();
        } else {
            promise1.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$deleteTopics$5(Promise promise, Void v, Throwable ex) {
        if (ex == null) {
            promise.complete();
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$createTopics$4(Promise promise, Void v, Throwable ex) {
        if (ex == null) {
            promise.complete();
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$listTopics$3(Promise promise, Set topics, Throwable ex) {
        if (ex == null) {
            promise.complete((Object)topics);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeLogDirs$2(Promise promise, Map t, Throwable ex) {
        if (ex == null) {
            HashMap logDirsDescriptions = new HashMap();
            for (Map.Entry logDirsDescriptionsEntry : t.entrySet()) {
                Integer broker = (Integer)logDirsDescriptionsEntry.getKey();
                HashMap logDirsDescription = new HashMap();
                for (Map.Entry logDirsDescriptionEntry : ((Map)logDirsDescriptionsEntry.getValue()).entrySet()) {
                    logDirsDescription.put(logDirsDescriptionEntry.getKey(), logDirsDescriptionEntry.getValue());
                }
                logDirsDescriptions.put(broker, logDirsDescription);
            }
            promise.complete(logDirsDescriptions);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeTopics$1(Promise promise, Map t, Throwable ex) {
        if (ex == null) {
            HashMap topics = new HashMap();
            for (Map.Entry topicDescriptionEntry : t.entrySet()) {
                ArrayList<io.vertx.kafka.client.common.TopicPartitionInfo> partitions = new ArrayList<io.vertx.kafka.client.common.TopicPartitionInfo>();
                for (TopicPartitionInfo kafkaPartitionInfo : ((org.apache.kafka.clients.admin.TopicDescription)topicDescriptionEntry.getValue()).partitions()) {
                    io.vertx.kafka.client.common.TopicPartitionInfo topicPartitionInfo = new io.vertx.kafka.client.common.TopicPartitionInfo();
                    topicPartitionInfo.setIsr(kafkaPartitionInfo.isr().stream().map(Helper::from).collect(Collectors.toList())).setLeader(Helper.from(kafkaPartitionInfo.leader())).setPartition(kafkaPartitionInfo.partition()).setReplicas(kafkaPartitionInfo.replicas().stream().map(Helper::from).collect(Collectors.toList()));
                    partitions.add(topicPartitionInfo);
                }
                TopicDescription topicDescription = new TopicDescription();
                topicDescription.setInternal(((org.apache.kafka.clients.admin.TopicDescription)topicDescriptionEntry.getValue()).isInternal()).setName((String)topicDescriptionEntry.getKey()).setPartitions(partitions);
                topics.put(topicDescriptionEntry.getKey(), topicDescription);
            }
            promise.complete(topics);
        } else {
            promise.fail(ex);
        }
    }

    private static /* synthetic */ void lambda$describeTopics$0(Promise promise, Map t, Throwable ex) {
        if (ex == null) {
            HashMap topics = new HashMap();
            for (Map.Entry topicDescriptionEntry : t.entrySet()) {
                ArrayList<io.vertx.kafka.client.common.TopicPartitionInfo> partitions = new ArrayList<io.vertx.kafka.client.common.TopicPartitionInfo>();
                for (TopicPartitionInfo kafkaPartitionInfo : ((org.apache.kafka.clients.admin.TopicDescription)topicDescriptionEntry.getValue()).partitions()) {
                    io.vertx.kafka.client.common.TopicPartitionInfo topicPartitionInfo = new io.vertx.kafka.client.common.TopicPartitionInfo();
                    topicPartitionInfo.setIsr(kafkaPartitionInfo.isr().stream().map(Helper::from).collect(Collectors.toList())).setLeader(Helper.from(kafkaPartitionInfo.leader())).setPartition(kafkaPartitionInfo.partition()).setReplicas(kafkaPartitionInfo.replicas().stream().map(Helper::from).collect(Collectors.toList()));
                    partitions.add(topicPartitionInfo);
                }
                TopicDescription topicDescription = new TopicDescription();
                topicDescription.setInternal(((org.apache.kafka.clients.admin.TopicDescription)topicDescriptionEntry.getValue()).isInternal()).setName((String)topicDescriptionEntry.getKey()).setPartitions(partitions);
                topics.put(topicDescriptionEntry.getKey(), topicDescription);
            }
            promise.complete(topics);
        } else {
            promise.fail(ex);
        }
    }
}

