/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCheckpointCommit;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.commit.ProcessingState;
import io.vertx.core.json.Json;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.kafka.common.TopicPartition;

@Experimental(value="Experimental API")
public class KafkaFileCheckpointCommit
extends KafkaCheckpointCommit {
    public static final String FILE_CHECKPOINT_NAME = "checkpoint-file";
    private final Vertx mutinyVertx;
    private final File stateDir;

    public KafkaFileCheckpointCommit(KafkaConnectorIncomingConfiguration config, Vertx vertx, KafkaConsumer<?, ?> consumer, BiConsumer<Throwable, Boolean> reportFailure, int defaultTimeout, File stateDir) {
        super(vertx, config, consumer, reportFailure, defaultTimeout);
        this.mutinyVertx = vertx;
        this.stateDir = stateDir;
    }

    private String getStatePath(TopicPartition partition) {
        return this.stateDir.toPath().resolve(partition.topic() + "-" + partition.partition()).toString();
    }

    @Override
    protected Uni<ProcessingState<?>> fetchProcessingState(TopicPartition partition) {
        String statePath = this.getStatePath(partition);
        return this.mutinyVertx.fileSystem().exists(statePath).chain(exists -> {
            if (exists.booleanValue()) {
                return this.mutinyVertx.fileSystem().readFile(statePath).map(this::deserializeState).onFailure().invoke(t -> this.log.errorf((Throwable)t, "Error fetching processing state for partition %s", partition)).onItem().invoke(r -> this.log.debugf("Fetched state for partition %s : %s", partition, r));
            }
            return Uni.createFrom().item(() -> null);
        });
    }

    private <T> ProcessingState<T> deserializeState(Buffer b) {
        return (ProcessingState)Json.decodeValue((io.vertx.core.buffer.Buffer)b.getDelegate(), ProcessingState.class);
    }

    @Override
    protected Uni<Void> persistProcessingState(TopicPartition partition, ProcessingState<?> state) {
        String statePath = this.getStatePath(partition);
        if (state != null) {
            return this.mutinyVertx.fileSystem().exists(statePath).chain(exists -> {
                if (exists.booleanValue()) {
                    return this.fetchProcessingState(partition).onFailure().recoverWithNull();
                }
                return this.mutinyVertx.fileSystem().createFile(statePath).onItem().transform(x -> null).onFailure(t -> Optional.ofNullable(t.getCause()).map(Object::getClass).orElse(null) == FileAlreadyExistsException.class).recoverWithNull();
            }).chain(s -> {
                if (s != null && s.getOffset() > state.getOffset()) {
                    this.log.warnf("Skipping persist operation : higher offset found on store %d > %d", s.getOffset(), state.getOffset());
                    return Uni.createFrom().voidItem();
                }
                return this.mutinyVertx.fileSystem().writeFile(statePath, this.serializeState(state));
            }).onFailure().invoke(t -> this.log.errorf((Throwable)t, "Error persisting processing state `%s` for partition %s", state, partition)).onItem().invoke(r -> this.log.debugf("Persisted state for partition %s : %s -> %s", partition, state, r));
        }
        return Uni.createFrom().voidItem();
    }

    private Buffer serializeState(ProcessingState<?> state) {
        return Buffer.newInstance((io.vertx.core.buffer.Buffer)Json.encodeToBuffer(state));
    }

    @ApplicationScoped
    @Identifier(value="checkpoint-file")
    public static class Factory
    implements KafkaCommitHandler.Factory {
        @Override
        public KafkaCommitHandler create(KafkaConnectorIncomingConfiguration config, Vertx vertx, KafkaConsumer<?, ?> consumer, BiConsumer<Throwable, Boolean> reportFailure) {
            int defaultTimeout = config.config().getOptionalValue("default.api.timeout.ms", Integer.class).orElse(60000);
            String stateDir = (String)config.config().getValue("checkpoint-file.stateDir", String.class);
            return new KafkaFileCheckpointCommit(config, vertx, consumer, reportFailure, defaultTimeout, new File(stateDir));
        }
    }
}

