/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.HashSet;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreMasterPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreSlavePolicyConfiguration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;

public class SecurityFailoverTest
extends FailoverTest {
    protected ClientSession createSession(ClientSessionFactory sf, boolean isXA, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        ClientSession session = sf.createSession("a", "b", isXA, autoCommitSends, autoCommitAcks, sf.getServerLocator().isPreAcknowledge(), ackBatchSize);
        this.addClientSession(session);
        return session;
    }

    @Override
    protected ClientSession createSession(ClientSessionFactory sf, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        ClientSession session = sf.createSession("a", "b", false, autoCommitSends, autoCommitAcks, sf.getServerLocator().isPreAcknowledge(), ackBatchSize);
        this.addClientSession(session);
        return session;
    }

    @Override
    protected ClientSession createSession(ClientSessionFactory sf, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.createSession(sf, autoCommitSends, autoCommitAcks, sf.getServerLocator().getAckBatchSize());
    }

    @Override
    protected ClientSession createSession(ClientSessionFactory sf) throws Exception {
        return this.createSession(sf, true, true, sf.getServerLocator().getAckBatchSize());
    }

    @Override
    protected ClientSession createSession(ClientSessionFactory sf, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.createSession(sf, xa, autoCommitSends, autoCommitAcks, sf.getServerLocator().getAckBatchSize());
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration liveConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setSecurityEnabled(true).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreSlavePolicyConfiguration()).addConnectorConfiguration(liveConnector.getName(), liveConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(SecurityFailoverTest.basicClusterConnectionConfig((String)backupConnector.getName(), (String[])new String[]{liveConnector.getName()}));
        this.backupServer = this.createTestableServer(this.backupConfig);
        ActiveMQJAASSecurityManager securityManager = this.installSecurity(this.backupServer);
        securityManager.getConfiguration().setDefaultUser(null);
        this.liveConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setSecurityEnabled(true).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreMasterPolicyConfiguration()).addClusterConfiguration(SecurityFailoverTest.basicClusterConnectionConfig((String)liveConnector.getName(), (String[])new String[0])).addConnectorConfiguration(liveConnector.getName(), liveConnector);
        this.liveServer = this.createTestableServer(this.liveConfig);
        this.installSecurity(this.liveServer);
    }

    @Override
    protected void beforeRestart(TestableServer server) {
        this.installSecurity(server);
    }

    protected ActiveMQJAASSecurityManager installSecurity(TestableServer server) {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getServer().getSecurityManager();
        securityManager.getConfiguration().addUser("a", "b");
        Role role = new Role("arole", true, true, true, true, true, true, true, true, true, true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        server.getServer().getSecurityRepository().addMatch("#", roles);
        securityManager.getConfiguration().addRole("a", "arole");
        return securityManager;
    }
}

