/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class GroupingTest
extends JMSTestBase {
    private Queue queue;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.queue = this.createQueue("TestQueue");
    }

    protected void setProperty(Message message) {
        ((ActiveMQMessage)message).getCoreMessage().putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, new SimpleString("foo"));
    }

    protected ConnectionFactory getCF() throws Exception {
        return this.cf;
    }

    @Test
    public void testGrouping() throws Exception {
        int j;
        ConnectionFactory fact = this.getCF();
        Connection connection = fact.createConnection();
        Session session = connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        MessageConsumer consumer1 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer3 = session.createConsumer((Destination)this.queue);
        connection.start();
        String jmsxgroupID = null;
        for (j = 0; j < 100; ++j) {
            TextMessage message = session.createTextMessage();
            message.setText("Message" + j);
            this.setProperty((Message)message);
            producer.send((Message)message);
            String prop = message.getStringProperty("JMSXGroupID");
            GroupingTest.assertNotNull((Object)prop);
            if (jmsxgroupID != null) {
                GroupingTest.assertEquals((Object)jmsxgroupID, (Object)prop);
                continue;
            }
            jmsxgroupID = prop;
        }
        for (j = 0; j < 100; ++j) {
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), jmsxgroupID);
        }
        connection.close();
    }

    @Test
    public void testGroupingWithJMS2Producer() throws Exception {
        int j;
        ConnectionFactory fact = this.getCF();
        Assume.assumeFalse((String)"only makes sense withOUT auto-group", (boolean)((ActiveMQConnectionFactory)fact).isAutoGroup());
        Assume.assumeTrue((String)"only makes sense withOUT explicit group-id", (((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0);
        String groupID = UUID.randomUUID().toString();
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        JMSProducer producer = ctx.createProducer().setProperty("JMSXGroupID", groupID);
        JMSConsumer consumer1 = ctx.createConsumer((Destination)this.queue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)this.queue);
        JMSConsumer consumer3 = ctx.createConsumer((Destination)this.queue);
        ctx.start();
        for (j = 0; j < 100; ++j) {
            TextMessage message = ctx.createTextMessage("Message" + j);
            producer.send((Destination)this.queue, (Message)message);
            String prop = message.getStringProperty("JMSXGroupID");
            GroupingTest.assertNotNull((Object)prop);
            GroupingTest.assertEquals((Object)groupID, (Object)prop);
        }
        ctx.commit();
        for (j = 0; j < 100; ++j) {
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)groupID);
            tm = (TextMessage)consumer2.receiveNoWait();
            GroupingTest.assertNull((Object)tm);
            tm = (TextMessage)consumer3.receiveNoWait();
            GroupingTest.assertNull((Object)tm);
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testManyGroups() throws Exception {
        ConnectionFactory fact = this.getCF();
        Assume.assumeFalse((String)"only makes sense withOUT auto-group", (boolean)((ActiveMQConnectionFactory)fact).isAutoGroup());
        Connection connection = fact.createConnection();
        Session session = connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        MessageConsumer consumer1 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer3 = session.createConsumer((Destination)this.queue);
        connection.start();
        for (int j = 0; j < 1000; ++j) {
            TextMessage message = session.createTextMessage();
            message.setText("Message" + j);
            message.setStringProperty("_AMQ_GROUP_ID", "" + j % 10);
            producer.send((Message)message);
            String prop = message.getStringProperty("JMSXGroupID");
            GroupingTest.assertNotNull((Object)prop);
        }
        int msg1 = this.flushMessages(consumer1);
        int msg2 = this.flushMessages(consumer2);
        int msg3 = this.flushMessages(consumer3);
        GroupingTest.assertNotSame((Object)0, (Object)msg1);
        GroupingTest.assertNotSame((Object)0, (Object)msg2);
        GroupingTest.assertNotSame((Object)0, (Object)msg2);
        consumer1.close();
        consumer2.close();
        consumer3.close();
        connection.close();
    }

    @Test
    public void testGroupingRollbackOnClose() throws Exception {
        TextMessage tm;
        int j;
        ActiveMQConnectionFactory fact = (ActiveMQConnectionFactory)this.getCF();
        fact.setConsumerWindowSize(1000);
        fact.setTransactionBatchSize(0);
        Connection connection = fact.createConnection();
        RemotingConnection rc = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
        Connection connection2 = fact.createConnection();
        Session session = connection.createSession(true, 0);
        Session session2 = connection2.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        MessageConsumer consumer1 = session.createConsumer((Destination)this.queue);
        MessageConsumer consumer2 = session2.createConsumer((Destination)this.queue);
        connection.start();
        connection2.start();
        String jmsxgroupID = null;
        for (j = 0; j < 100; ++j) {
            TextMessage message = session.createTextMessage();
            message.setText("Message" + j);
            this.setProperty((Message)message);
            producer.send((Message)message);
            String prop = message.getStringProperty("JMSXGroupID");
            GroupingTest.assertNotNull((Object)prop);
            if (jmsxgroupID != null) {
                GroupingTest.assertEquals((Object)jmsxgroupID, (Object)prop);
                continue;
            }
            jmsxgroupID = prop;
        }
        session.commit();
        for (j = 0; j < 1; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)jmsxgroupID);
        }
        rc.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException()));
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer2.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            long text = ((ActiveMQTextMessage)tm).getCoreMessage().getMessageID();
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)jmsxgroupID);
        }
        connection.close();
        connection2.close();
    }

    private int flushMessages(MessageConsumer consumer) throws JMSException {
        TextMessage msg;
        int received = 0;
        while ((msg = (TextMessage)consumer.receiveNoWait()) != null) {
            msg.acknowledge();
            ++received;
        }
        return received;
    }

    @Test
    public void testGroupBuckets() throws Exception {
        TextMessage tm;
        int j;
        ConnectionFactory fact = this.getCF();
        Assume.assumeFalse((String)"only makes sense withOUT auto-group", (boolean)((ActiveMQConnectionFactory)fact).isAutoGroup());
        Assume.assumeTrue((String)"only makes sense withOUT explicit group-id", (((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0);
        String testQueueName = this.getName() + "_bucket_group";
        this.server.createQueue(new QueueConfiguration(testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupBuckets(Integer.valueOf(2)));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        GroupingTest.assertEquals((long)(("groupA".hashCode() & Integer.MAX_VALUE) % 2), (long)0L);
        GroupingTest.assertEquals((long)(("groupB".hashCode() & Integer.MAX_VALUE) % 2), (long)1L);
        GroupingTest.assertEquals((long)(("groupC".hashCode() & Integer.MAX_VALUE) % 2), (long)0L);
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer3 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupA");
            tm = (TextMessage)consumer2.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + (j + 10)), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupB");
            GroupingTest.assertNull((Object)consumer3.receiveNoWait());
        }
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
            GroupingTest.assertNull((Object)consumer2.receiveNoWait());
            GroupingTest.assertNull((Object)consumer3.receiveNoWait());
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testGroupRebalance() throws Exception {
        TextMessage tm;
        int j;
        TextMessage tm2;
        int j2;
        ConnectionFactory fact = this.getCF();
        Assume.assumeFalse((String)"only makes sense withOUT auto-group", (boolean)((ActiveMQConnectionFactory)fact).isAutoGroup());
        Assume.assumeTrue((String)"only makes sense withOUT explicit group-id", (((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0);
        String testQueueName = this.getName() + "_group_rebalance";
        this.server.createQueue(new QueueConfiguration(testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupRebalance(Boolean.valueOf(true)));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j2 = 0; j2 < 10; ++j2) {
            this.send(ctx, testQueue, "groupA", producer1, j2);
        }
        for (j2 = 10; j2 < 20; ++j2) {
            this.send(ctx, testQueue, "groupB", producer2, j2);
        }
        for (j2 = 20; j2 < 30; ++j2) {
            this.send(ctx, testQueue, "groupC", producer3, j2);
        }
        ctx.commit();
        for (j2 = 0; j2 < 10; ++j2) {
            tm2 = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm2);
            tm2.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            GroupingTest.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupA");
        }
        for (j2 = 10; j2 < 20; ++j2) {
            tm2 = (TextMessage)consumer2.receive(10000L);
            GroupingTest.assertNotNull((Object)tm2);
            tm2.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            GroupingTest.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupB");
        }
        for (j2 = 20; j2 < 30; ++j2) {
            tm2 = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm2);
            tm2.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            GroupingTest.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupC");
        }
        ctx.commit();
        JMSConsumer consumer3 = ctx.createConsumer((Destination)testQueue);
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupA");
        }
        for (j = 10; j < 20; ++j) {
            tm = (TextMessage)consumer2.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupB");
        }
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer3.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testGroupRebalancePauseDispatch() throws Exception {
        TextMessage tm;
        int j;
        TextMessage tm2;
        int j2;
        ConnectionFactory fact = this.getCF();
        Assume.assumeFalse((String)"only makes sense withOUT auto-group", (boolean)((ActiveMQConnectionFactory)fact).isAutoGroup());
        Assume.assumeTrue((String)"only makes sense withOUT explicit group-id", (((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0);
        String testQueueName = this.getName() + "_group_rebalance";
        this.server.createQueue(new QueueConfiguration(testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupRebalance(Boolean.valueOf(true)).setGroupRebalancePauseDispatch(Boolean.valueOf(true)));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j2 = 0; j2 < 10; ++j2) {
            this.send(ctx, testQueue, "groupA", producer1, j2);
        }
        for (j2 = 10; j2 < 20; ++j2) {
            this.send(ctx, testQueue, "groupB", producer2, j2);
        }
        for (j2 = 20; j2 < 30; ++j2) {
            this.send(ctx, testQueue, "groupC", producer3, j2);
        }
        ctx.commit();
        for (j2 = 0; j2 < 10; ++j2) {
            tm2 = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm2);
            tm2.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            GroupingTest.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupA");
        }
        ctx.commit();
        for (j2 = 10; j2 < 20; ++j2) {
            tm2 = (TextMessage)consumer2.receive(10000L);
            GroupingTest.assertNotNull((Object)tm2);
            tm2.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j2), (Object)tm2.getText());
            GroupingTest.assertEquals((Object)tm2.getStringProperty("JMSXGroupID"), (Object)"groupB");
        }
        ctx.commit();
        JMSConsumer consumer3 = ctx.createConsumer((Destination)testQueue);
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        GroupingTest.assertNull((Object)consumer2.receiveNoWait());
        GroupingTest.assertNull((Object)consumer3.receiveNoWait());
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
        }
        ctx.commit();
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupA");
        }
        for (j = 10; j < 20; ++j) {
            tm = (TextMessage)consumer2.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupB");
        }
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer3.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testGroupFirstKey() throws Exception {
        TextMessage tm;
        int j;
        String customFirstGroupKey = "my-custom-key";
        ConnectionFactory fact = this.getCF();
        Assume.assumeFalse((String)"only makes sense withOUT auto-group", (boolean)((ActiveMQConnectionFactory)fact).isAutoGroup());
        Assume.assumeTrue((String)"only makes sense withOUT explicit group-id", (((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0);
        String testQueueName = this.getName() + "_group_first_key";
        this.server.createQueue(new QueueConfiguration(testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupRebalance(Boolean.valueOf(true)).setGroupFirstKey(customFirstGroupKey));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        for (j = 0; j < 10; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupA");
            if (j == 0) {
                GroupingTest.assertTrue((boolean)tm.getBooleanProperty(customFirstGroupKey));
                continue;
            }
            GroupingTest.assertFalse((boolean)tm.propertyExists(customFirstGroupKey));
        }
        for (j = 10; j < 20; ++j) {
            tm = (TextMessage)consumer2.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupB");
            if (j == 10) {
                GroupingTest.assertTrue((boolean)tm.getBooleanProperty(customFirstGroupKey));
                continue;
            }
            GroupingTest.assertFalse((boolean)tm.propertyExists(customFirstGroupKey));
        }
        for (j = 20; j < 30; ++j) {
            tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)"groupC");
            if (j == 20) {
                GroupingTest.assertTrue((boolean)tm.getBooleanProperty(customFirstGroupKey));
                continue;
            }
            GroupingTest.assertFalse((boolean)tm.propertyExists(customFirstGroupKey));
        }
        ctx.commit();
        ctx.close();
    }

    @Test
    public void testGroupDisable() throws Exception {
        int j;
        ConnectionFactory fact = this.getCF();
        Assume.assumeFalse((String)"only makes sense withOUT auto-group", (boolean)((ActiveMQConnectionFactory)fact).isAutoGroup());
        Assume.assumeTrue((String)"only makes sense withOUT explicit group-id", (((ActiveMQConnectionFactory)fact).getGroupID() == null ? 1 : 0) != 0);
        String testQueueName = this.getName() + "_group_disable";
        this.server.createQueue(new QueueConfiguration(testQueueName).setRoutingType(RoutingType.ANYCAST).setGroupBuckets(Integer.valueOf(0)));
        JMSContext ctx = this.addContext(this.getCF().createContext(0));
        Queue testQueue = ctx.createQueue(testQueueName);
        String groupID1 = "groupA";
        String groupID2 = "groupB";
        String groupID3 = "groupC";
        JMSProducer producer1 = ctx.createProducer().setProperty("JMSXGroupID", "groupA");
        JMSProducer producer2 = ctx.createProducer().setProperty("JMSXGroupID", "groupB");
        JMSProducer producer3 = ctx.createProducer().setProperty("JMSXGroupID", "groupC");
        JMSConsumer consumer1 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer2 = ctx.createConsumer((Destination)testQueue);
        JMSConsumer consumer3 = ctx.createConsumer((Destination)testQueue);
        ctx.start();
        for (j = 0; j < 10; ++j) {
            this.send(ctx, testQueue, "groupA", producer1, j);
        }
        for (j = 10; j < 20; ++j) {
            this.send(ctx, testQueue, "groupB", producer2, j);
        }
        for (j = 20; j < 30; ++j) {
            this.send(ctx, testQueue, "groupC", producer3, j);
        }
        ctx.commit();
        for (j = 0; j < 30; ++j) {
            TextMessage tm = (TextMessage)consumer1.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)(j < 10 ? "groupA" : (j < 20 ? "groupB" : "groupC")));
            tm = (TextMessage)consumer2.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + ++j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)(j < 10 ? "groupA" : (j < 20 ? "groupB" : "groupC")));
            tm = (TextMessage)consumer3.receive(10000L);
            GroupingTest.assertNotNull((Object)tm);
            tm.acknowledge();
            GroupingTest.assertEquals((Object)("Message" + ++j), (Object)tm.getText());
            GroupingTest.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)(j < 10 ? "groupA" : (j < 20 ? "groupB" : "groupC")));
        }
        ctx.commit();
        ctx.close();
    }

    private void send(JMSContext ctx, Queue testQueue, String groupID1, JMSProducer producer1, int j) throws JMSException {
        TextMessage message = ctx.createTextMessage("Message" + j);
        producer1.send((Destination)testQueue, (Message)message);
        String prop = message.getStringProperty("JMSXGroupID");
        GroupingTest.assertNotNull((Object)prop);
        GroupingTest.assertEquals((Object)groupID1, (Object)prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupBucketUsingAddressQueueParameters() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName() + "group_bucket_param";
            Queue queue = session.createQueue(testQueueName + "?group-buckets=4");
            GroupingTest.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            GroupingTest.assertEquals((Object)4, (Object)a.getQueueAttributes().getGroupBuckets());
            GroupingTest.assertEquals((Object)4, (Object)a.getQueueConfiguration().getGroupBuckets());
            MessageProducer producer = session.createProducer((Destination)queue);
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            GroupingTest.assertEquals((long)4L, (long)queueBinding.getQueue().getGroupBuckets());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupRebalanceUsingAddressQueueParameters() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName() + "group_rebalance_param";
            Queue queue = session.createQueue(testQueueName + "?group-rebalance=true");
            GroupingTest.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            GroupingTest.assertTrue((boolean)a.getQueueAttributes().getGroupRebalance());
            GroupingTest.assertTrue((boolean)a.getQueueConfiguration().isGroupRebalance());
            MessageProducer producer = session.createProducer((Destination)queue);
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            GroupingTest.assertTrue((boolean)queueBinding.getQueue().isGroupRebalance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupFirstKeyUsingAddressQueueParameters() throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            String testQueueName = this.getName() + "group_first_key_param";
            Queue queue = session.createQueue(testQueueName + "?group-first-key=my-custom-key");
            GroupingTest.assertEquals((Object)testQueueName, (Object)queue.getQueueName());
            ActiveMQDestination a = (ActiveMQDestination)queue;
            GroupingTest.assertEquals((Object)"my-custom-key", (Object)a.getQueueAttributes().getGroupFirstKey().toString());
            MessageProducer producer = session.createProducer((Destination)queue);
            QueueBinding queueBinding = (QueueBinding)this.server.getPostOffice().getBinding(SimpleString.toSimpleString((String)testQueueName));
            GroupingTest.assertEquals((Object)"my-custom-key", (Object)queueBinding.getQueue().getGroupFirstKey().toString());
        }
    }
}

