/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.Assert;
import org.junit.Test;

public class RelativePathTest
extends ActiveMQTestBase {
    @Test
    public void testRelativePathOnDefaultConfig() throws Exception {
        Configuration configuration = this.createDefaultConfig(false);
        ActiveMQServer server = this.createServer(true, configuration, 0xA00000, -1L, new HashMap());
        server.start();
        server.stop();
        this.checkData(new File(configuration.getJournalDirectory()), ".amq");
        this.checkData(new File(configuration.getBindingsDirectory()), ".bindings");
    }

    @Test
    public void testDataOutsideHome() throws Exception {
        Configuration configuration = this.createDefaultConfig(false);
        File instanceHome = new File(this.getTemporaryDir(), "artemisHome");
        configuration.setBrokerInstance(instanceHome);
        File journalOutside = new File(this.getTemporaryDir(), "./journalOut").getAbsoluteFile();
        configuration.setJournalDirectory(journalOutside.getAbsolutePath());
        configuration.setBindingsDirectory("./bind");
        File bindingsInside = new File(instanceHome, "bind");
        ActiveMQServer server = this.createServer(true, configuration, 0xA00000, -1L, new HashMap());
        server.start();
        server.stop();
        this.checkData(journalOutside, ".amq");
        this.checkData(journalOutside, "server.lock");
        this.checkData(bindingsInside, ".bindings");
    }

    @Test
    public void testRelativePath() throws Exception {
        Configuration configuration = this.createDefaultConfig(false);
        File instanceHome = new File(this.getTemporaryDir(), "artemisHome");
        File dataHome = new File(instanceHome, "data");
        File bindingsHome = new File(instanceHome, "../binx");
        instanceHome.mkdirs();
        configuration.setBrokerInstance(instanceHome);
        configuration.setJournalDirectory("./data");
        configuration.setPagingDirectory("./paging");
        configuration.setBindingsDirectory("../binx");
        configuration.setLargeMessagesDirectory("./large");
        ActiveMQServer server = this.createServer(true, configuration, 0xA00000, -1L, new HashMap());
        server.start();
        server.stop();
        this.checkData(dataHome, ".amq");
        this.checkData(bindingsHome, ".bindings");
    }

    public void checkData(File dataHome, final String extension) {
        Assert.assertTrue((String)("Folder " + dataHome + " doesn't exist"), (boolean)dataHome.exists());
        File[] files = dataHome.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return extension == null || pathname.toString().endsWith(extension);
            }
        });
        Assert.assertNotNull((Object)files);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
    }
}

