/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.util;

import java.util.HashSet;
import org.apache.activemq.artemis.tests.util.SpawnedVMCheck;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class RandomUtilDistributionTest {
    private static final Logger log = Logger.getLogger(RandomUtilDistributionTest.class);
    @Rule
    public SpawnedVMCheck check = new SpawnedVMCheck();

    public static void main(String[] arg) {
        long start = Long.parseLong(arg[0]);
        try {
            Thread.sleep((start - System.currentTimeMillis()) / 2L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (System.currentTimeMillis() < start) {
            Thread.yield();
        }
        int value = RandomUtil.randomInterval((int)0, (int)255);
        System.exit(value);
    }

    @Test
    public void testDistribution() throws Exception {
        int numberOfStarts = 50;
        int iterations = 1;
        int value = 0;
        for (int i = 0; i < iterations; ++i) {
            int v = this.internalDistributionTest(numberOfStarts);
            value += v;
        }
        int minimumExpected = (int)((double)(iterations * numberOfStarts) * 0.8);
        log.debug((Object)("values = " + value + ", minimum expected = " + minimumExpected));
        Assert.assertTrue((String)("The Random distribution is pretty bad. Many tries have returned duplicated randoms. Number of different values=" + value + ", minimum expected = " + minimumExpected), (value >= minimumExpected ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalDistributionTest(int numberOfTries) throws Exception {
        long timeStart = System.currentTimeMillis() + 5000L;
        Process[] process = new Process[numberOfTries];
        int[] value = new int[numberOfTries];
        try {
            for (int i = 0; i < numberOfTries; ++i) {
                process[i] = SpawnedVMSupport.spawnVM((String)RandomUtilDistributionTest.class.getName(), (boolean)true, (String[])new String[]{"" + timeStart});
            }
            HashSet<Integer> valueSet = new HashSet<Integer>();
            for (int i = 0; i < numberOfTries; ++i) {
                value[i] = process[i].waitFor();
                Assert.assertTrue((value[i] >= 0 ? 1 : 0) != 0);
                valueSet.add(process[i].exitValue());
            }
            log.debug((Object)("Generated " + valueSet.size() + " randoms out of  " + numberOfTries + " tries"));
            int n = valueSet.size();
            return n;
        }
        finally {
            for (Process p : process) {
                if (p == null) continue;
                p.destroy();
            }
        }
    }
}

