/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.context.Flag;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.util.concurrent.BlockingManager;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanMutatorFactory;
import org.wildfly.clustering.ejb.PassivationListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFilter;
import org.wildfly.clustering.ejb.infinispan.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroup;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.group.InfinispanBeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.infinispan.listener.ListenerRegistration;
import org.wildfly.clustering.infinispan.listener.PostActivateBlockingListener;
import org.wildfly.clustering.infinispan.listener.PrePassivateBlockingListener;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;

public class InfinispanBeanGroupFactory<I, T, C>
implements BeanGroupFactory<I, T, C> {
    private final Cache<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> cache;
    private final Cache<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> findCache;
    private final Cache<BeanKey<I>, BeanEntry<I>> beanCache;
    private final Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> beanFilter;
    private final MarshalledValueFactory<C> factory;
    private final PassivationListener<T> passivationListener;
    private final MutatorFactory<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> mutatorFactory;
    private final ListenerRegistration prePassivateListenerRegistration;
    private final ListenerRegistration postActivateListenerRegistration;
    private final Executor executor;

    public InfinispanBeanGroupFactory(Cache<BeanGroupKey<I>, BeanGroupEntry<I, T, C>> cache, Cache<BeanKey<I>, BeanEntry<I>> beanCache, Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> beanFilter, MarshalledValueFactory<C> factory, CacheProperties properties, PassivationConfiguration<T> passivation) {
        this.cache = cache;
        this.findCache = properties.isLockOnRead() ? cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK) : cache;
        this.beanCache = beanCache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_LISTENER_NOTIFICATION});
        this.beanFilter = beanFilter;
        this.factory = factory;
        this.passivationListener = !properties.isPersistent() ? passivation.getPassivationListener() : null;
        BlockingManager blocking = (BlockingManager)cache.getCacheManager().getGlobalComponentRegistry().getComponent(BlockingManager.class);
        this.executor = blocking.asExecutor(this.getClass().getName());
        this.prePassivateListenerRegistration = new PrePassivateBlockingListener(this.cache, this::prePassivate).register((CacheEventFilter)BeanGroupFilter.INSTANCE);
        this.postActivateListenerRegistration = new PostActivateBlockingListener(this.cache, this::postActivate).register((CacheEventFilter)BeanGroupFilter.INSTANCE);
        this.mutatorFactory = new InfinispanMutatorFactory((Cache)cache, properties);
    }

    @Override
    public void close() {
        this.prePassivateListenerRegistration.close();
        this.postActivateListenerRegistration.close();
    }

    @Override
    public int getPassiveCount() {
        return this.cache.getCacheConfiguration().persistence().passivation() ? this.count(EnumSet.noneOf(Flag.class)) - this.count(EnumSet.of(Flag.SKIP_CACHE_LOAD)) : 0;
    }

    private int count(Set<Flag> flags) {
        AdvancedCache cache = flags.isEmpty() ? this.beanCache : this.beanCache.getAdvancedCache().withFlags(flags);
        try (CacheStream keys = cache.keySet().stream();){
            int n = (int)keys.filter(InfinispanBeanKey.class::isInstance).count();
            return n;
        }
    }

    @Override
    public BeanGroupKey<I> createKey(I id) {
        return new InfinispanBeanGroupKey<I>(id);
    }

    public BeanGroupEntry<I, T, C> createValue(I id, Void context) {
        InfinispanBeanGroupEntry entry = new InfinispanBeanGroupEntry(this.factory.createMarshalledValue(new ConcurrentHashMap()));
        this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put(this.createKey(id), entry);
        return entry;
    }

    public BeanGroupEntry<I, T, C> findValue(I id) {
        return (BeanGroupEntry)this.findCache.get(this.createKey(id));
    }

    public BeanGroupEntry<I, T, C> tryValue(I id) {
        return (BeanGroupEntry)this.findCache.getAdvancedCache().withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY}).get(this.createKey(id));
    }

    public boolean remove(I id) {
        this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).remove(this.createKey(id));
        return true;
    }

    @Override
    public BeanGroup<I, T> createGroup(I id, BeanGroupEntry<I, T, C> entry) {
        return this.createGroup(id, entry, this.mutatorFactory.createMutator(this.createKey(id), entry));
    }

    private BeanGroup<I, T> createGroup(I id, BeanGroupEntry<I, T, C> entry, Mutator mutator) {
        return new InfinispanBeanGroup<I, T, Object>(id, entry, this.factory.getMarshallingContext(), mutator, this);
    }

    @Override
    public void evict(I id) {
        this.cache.evict(new InfinispanBeanGroupKey<I>(id));
    }

    void prePassivate(BeanGroupKey<I> key, BeanGroupEntry<I, T, C> entry) {
        try (InfinispanBeanGroup<Object, T, Object> group = new InfinispanBeanGroup<Object, T, Object>(key.getId(), entry, this.factory.getMarshallingContext(), Mutator.PASSIVE, this);){
            Set beans = group.getBeans();
            ArrayList notified = new ArrayList(beans.size());
            try {
                for (Object beanId : beans) {
                    InfinispanBeanKey beanKey = new InfinispanBeanKey(beanId);
                    BeanEntry beanEntry = (BeanEntry)this.beanCache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).get(beanKey);
                    if (beanEntry == null || !this.beanFilter.test(new AbstractMap.SimpleImmutableEntry(beanKey, beanEntry))) continue;
                    InfinispanEjbLogger.ROOT_LOGGER.tracef("Passivating bean %s", beanKey);
                    group.prePassivate(beanId, this.passivationListener);
                    notified.add(beanId);
                    this.executor.execute(() -> this.beanCache.evict((Object)beanKey));
                }
            }
            catch (Error | RuntimeException e) {
                for (Object beanId : notified) {
                    try {
                        group.postActivate(beanId, this.passivationListener);
                    }
                    catch (Error | RuntimeException ex) {
                        InfinispanEjbLogger.ROOT_LOGGER.warn(ex.getLocalizedMessage(), ex);
                    }
                }
                throw e;
            }
        }
    }

    void postActivate(BeanGroupKey<I> key, BeanGroupEntry<I, T, C> entry) {
        Object context = this.factory.getMarshallingContext();
        try (InfinispanBeanGroup<Object, T, Object> group = new InfinispanBeanGroup<Object, T, Object>(key.getId(), entry, context, Mutator.PASSIVE, this);){
            for (Object beanId : group.getBeans()) {
                InfinispanBeanKey beanKey = new InfinispanBeanKey(beanId);
                BeanEntry beanEntry = (BeanEntry)this.beanCache.get(beanKey);
                if (beanEntry == null || !this.beanFilter.test(new AbstractMap.SimpleImmutableEntry(beanKey, beanEntry))) continue;
                InfinispanEjbLogger.ROOT_LOGGER.tracef("Activating bean %s", beanKey);
                try {
                    group.postActivate(beanId, this.passivationListener);
                }
                catch (Error | RuntimeException e) {
                    InfinispanEjbLogger.ROOT_LOGGER.warn(e.getLocalizedMessage(), e);
                }
            }
        }
    }
}

