/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.microprofile.opentracing.SubsystemDefinition;
import org.wildfly.microprofile.opentracing.smallrye.WildFlyTracerFactory;

public class TracingDependencyProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) {
        ServiceName tracerConfiguration;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        this.addDependencies(deploymentUnit);
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        if (support.hasCapability("org.wildfly.microprofile.opentracing.default-tracer")) {
            phaseContext.getServiceTarget().addDependency(SubsystemDefinition.DEFAULT_TRACER_CAPABILITY.getCapabilityServiceName());
        }
        if ((tracerConfiguration = this.getTracerConfigurationServiceDependency(phaseContext)) != null) {
            phaseContext.getServiceTarget().addDependency(tracerConfiguration);
        }
    }

    private JBossWebMetaData getJBossWebMetaData(DeploymentUnit deploymentUnit) {
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (null == warMetaData) {
            return null;
        }
        return warMetaData.getMergedJBossWebMetaData();
    }

    private ServiceName getTracerConfigurationServiceDependency(DeploymentPhaseContext deploymentPhaseContext) {
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(deploymentUnit);
        if (null == jbossWebMetaData || null == jbossWebMetaData.getContextParams()) {
            return null;
        }
        for (ParamValueMetaData param : jbossWebMetaData.getContextParams()) {
            String value;
            if (!"mp.opentracing.extensions.tracer.configuration".equals(param.getParamName()) || (value = param.getParamValue()) == null || value.isEmpty()) continue;
            return SubsystemDefinition.TRACER_CAPABILITY.getCapabilityServiceName(new String[]{value});
        }
        return null;
    }

    private void addDependencies(DeploymentUnit deploymentUnit) {
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        for (String module : SubsystemDefinition.MODULES) {
            if (module.contains("io.smallrye.opentracing-contrib")) continue;
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, module, false, false, true, false));
        }
        for (String module : SubsystemDefinition.EXPORTED_MODULES) {
            ModuleDependency modDep = new ModuleDependency(moduleLoader, module, false, true, true, false);
            if (module.contains("io.smallrye.opentracing-contrib")) {
                modDep.addImportFilter(s -> s.equals("META-INF"), true);
            }
            moduleSpecification.addSystemDependency(modDep);
        }
        for (String module : WildFlyTracerFactory.getModules()) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, module, true, false, true, false));
        }
    }
}

