/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.StandardVirtualTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.AnyType;
import org.hibernate.type.descriptor.java.JavaType;

public class DiscriminatedCollectionPart
implements DiscriminatedAssociationModelPart,
CollectionPart {
    private final CollectionPart.Nature nature;
    private final NavigableRole partRole;
    private final CollectionPersister collectionDescriptor;
    private final DiscriminatedAssociationMapping discriminatorMapping;

    public DiscriminatedCollectionPart(CollectionPart.Nature nature, CollectionPersister collectionDescriptor, JavaType<Object> baseAssociationJtd, Any bootValueMapping, AnyType anyType, MappingModelCreationProcess creationProcess) {
        this.nature = nature;
        this.partRole = collectionDescriptor.getNavigableRole().append(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.discriminatorMapping = DiscriminatedAssociationMapping.from(this.partRole, baseAssociationJtd, this, anyType, bootValueMapping, creationProcess);
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public BasicValuedModelPart getDiscriminatorPart() {
        return this.discriminatorMapping.getDiscriminatorPart();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.discriminatorMapping.getKeyPart();
    }

    @Override
    public EntityMappingType resolveDiscriminatorValue(Object discriminatorValue) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityMapping(discriminatorValue);
    }

    @Override
    public Object resolveDiscriminatorForEntityType(EntityMappingType entityMappingType) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityMapping(entityMappingType);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        this.discriminatorMapping.getDiscriminatorPart().forEachSelectable(offset, consumer);
        this.discriminatorMapping.getKeyPart().forEachSelectable(offset + 1, consumer);
        return 2;
    }

    @Override
    public String getFetchableName() {
        return this.nature.getName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this.discriminatorMapping;
    }

    public String toString() {
        return "DiscriminatedCollectionPart(" + this.getNavigableRole() + ")@" + System.identityHashCode(this);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.generateFetch(fetchParent, fetchablePath, fetchTiming, selected, resultVariable, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.discriminatorMapping.getDiscriminatorPart().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.discriminatorMapping.getDiscriminatorPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public MappingType getPartMappingType() {
        return this.discriminatorMapping;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.discriminatorMapping.getJavaType();
    }

    public JavaType<?> getExpressibleJavaType() {
        return this.getJavaType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.partRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.discriminatorMapping.findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.getDiscriminatorPart());
        consumer.accept(this.getKeyPart());
    }

    @Override
    public int getNumberOfFetchables() {
        return 2;
    }

    @Override
    public Fetchable getFetchable(int position) {
        switch (position) {
            case 0: {
                return this.getDiscriminatorPart();
            }
            case 1: {
                return this.getKeyPart();
            }
        }
        throw new IndexOutOfBoundsException(position);
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.discriminatorMapping.getDiscriminatorPart().disassemble(value, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.discriminatorMapping.getDiscriminatorPart().forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.discriminatorMapping.getDiscriminatorPart().breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = this.getDiscriminatorPart().forEachJdbcType(offset, action);
        return span + this.getKeyPart().forEachJdbcType(offset + span, action);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        SqlAstJoinType joinType = requestedJoinType == null ? SqlAstJoinType.INNER : requestedJoinType;
        TableGroup tableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, requestedJoinType, fetched, null, aliasBaseGenerator, sqlExpressionResolver, fromClauseAccess, creationContext);
        return new TableGroupJoin(navigablePath, joinType, tableGroup);
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType requestedJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, FromClauseAccess fromClauseAccess, SqlAstCreationContext creationContext) {
        return new StandardVirtualTableGroup(navigablePath, this, lhs, fetched);
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.LEFT;
    }

    @Override
    public String getSqlAliasStem() {
        return this.collectionDescriptor.getAttributeMapping().getSqlAliasStem();
    }
}

