/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.lang.reflect.ParameterizedType;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicCollectionJavaType;
import org.hibernate.type.descriptor.java.spi.UnknownBasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class CollectionJavaType<C>
extends AbstractClassJavaType<C> {
    private final CollectionSemantics<C, ?> semantics;

    public CollectionJavaType(Class<? extends C> type, CollectionSemantics<C, ?> semantics) {
        super(type);
        this.semantics = semantics;
    }

    public CollectionSemantics<C, ?> getSemantics() {
        return this.semantics;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return null;
    }

    @Override
    public JavaType<C> createJavaType(ParameterizedType parameterizedType, TypeConfiguration typeConfiguration) {
        switch (this.semantics.getCollectionClassification()) {
            case ARRAY: 
            case BAG: 
            case ID_BAG: 
            case LIST: 
            case SET: 
            case SORTED_SET: 
            case ORDERED_SET: {
                return new BasicCollectionJavaType(parameterizedType, typeConfiguration.getJavaTypeRegistry().resolveDescriptor(parameterizedType.getActualTypeArguments()[0]), this.semantics);
            }
        }
        return new UnknownBasicJavaType<Object>(parameterizedType, MutableMutabilityPlan.INSTANCE);
    }

    @Override
    public C fromString(CharSequence string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> X unwrap(C value, Class<X> type, WrapperOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <X> C wrap(X value, WrapperOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean areEqual(C one, C another) {
        return one == another || one instanceof PersistentCollection && ((PersistentCollection)one).wasInitialized() && ((PersistentCollection)one).isWrapper(another) || another instanceof PersistentCollection && ((PersistentCollection)another).wasInitialized() && ((PersistentCollection)another).isWrapper(one);
    }

    @Override
    public int extractHashCode(C x) {
        throw new UnsupportedOperationException();
    }
}

