/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer;

import io.undertow.util.HttpString;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.micrometer.MicrometerSubsystemDefinition;
import org.wildfly.extension.micrometer.metrics.WildFlyRegistry;

class MicrometerContextService
implements Service {
    public static final String CONTEXT = "/metrics";
    private final Consumer<MicrometerContextService> consumer;
    private final Supplier<ExtensibleHttpManagement> extensibleHttpManagement;
    private final Boolean securityEnabled;
    private final Supplier<WildFlyRegistry> registrySupplier;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    static void install(OperationContext context, boolean securityEnabled) {
        CapabilityServiceBuilder serviceBuilder = context.getCapabilityServiceTarget().addCapability(MicrometerSubsystemDefinition.MICROMETER_HTTP_CONTEXT_CAPABILITY);
        Supplier extensibleHttpManagement = serviceBuilder.requiresCapability("org.wildfly.management.http.extensible", ExtensibleHttpManagement.class, new String[0]);
        Supplier registrySupplier = serviceBuilder.requiresCapability(MicrometerSubsystemDefinition.MICROMETER_REGISTRY_RUNTIME_CAPABILITY.getName(), WildFlyRegistry.class, new String[0]);
        Consumer metricsContext = serviceBuilder.provides(new ServiceName[]{MicrometerSubsystemDefinition.MICROMETER_HTTP_CONTEXT_CAPABILITY.getCapabilityServiceName()});
        MicrometerContextService service = new MicrometerContextService(metricsContext, extensibleHttpManagement, securityEnabled, registrySupplier);
        serviceBuilder.setInstance((Service)service).install();
    }

    private MicrometerContextService(Consumer<MicrometerContextService> consumer, Supplier<ExtensibleHttpManagement> extensibleHttpManagement, Boolean securityEnabled, Supplier<WildFlyRegistry> registrySupplier) {
        this.consumer = consumer;
        this.extensibleHttpManagement = extensibleHttpManagement;
        this.securityEnabled = securityEnabled;
        this.registrySupplier = registrySupplier;
    }

    public void start(StartContext context) {
        this.extensibleHttpManagement.get().addManagementHandler(CONTEXT, this.securityEnabled.booleanValue(), exchange -> {
            this.lock.readLock().lock();
            try {
                exchange.getResponseHeaders().put(HttpString.tryFromString((String)"X-WildFly-Metrics"), "micrometer");
                exchange.getResponseSender().send(this.registrySupplier.get().scrape());
            }
            finally {
                this.lock.readLock().unlock();
            }
        });
        this.consumer.accept(this);
    }

    public void stop(StopContext context) {
        this.extensibleHttpManagement.get().removeContext(CONTEXT);
        this.consumer.accept(null);
    }
}

